@extends ('backend.layouts.app')

@section ('title', trans('labels.backend.contacts.management') . ' | ' . trans('labels.backend.contacts.create'))

@section('page-header')
    <h1>
        {{ trans('labels.backend.contacts.management') }}
        <small>{{ trans('labels.backend.contacts.create') }}</small>
    </h1>
@endsection

@section('content')
    {{ Form::open(['route' => 'admin.customers.contacts.store', 'class' => '', 'role' => 'form', 'method' => 'post' , 'enctype' => 'multipart/form-data']) }}

    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('labels.backend.contacts.create') }}</h3>
            <div class="box-tools pull-right">
                @include('backend.customers.leads.includes.partials.contacts-header-buttons')
            </div>
        </div><!-- /.box-header -->
        <div class="box-body">

            <div class="control-group">
                {{ Form::textGroup('fullname', trans('validation.attributes.backend.contacts.fullname'), 'info', ['placeholder' => trans('validation.attributes.backend.contacts.fullname')]) }}
                {{ Form::emailGroup('email', trans('validation.attributes.backend.contacts.email'), 'envelope', ['placeholder' => trans('validation.attributes.backend.contacts.email')]) }}
                {{ Form::textGroup('phone', trans('validation.attributes.backend.contacts.phone'), 'mobile', ['placeholder' => trans('validation.attributes.backend.contacts.phone')]) }}
                {{ Form::textGroup('address', trans('validation.attributes.backend.contacts.address'), 'address-card-o', ['placeholder' => trans('validation.attributes.backend.contacts.address')]) }}
                {{ Form::selectGroup('status', trans('validation.attributes.backend.plan.status'), 'caret-down', ['1'=>'Active','2'=>'Pending for Approval','3'=>'Suspended','4'=>'Blocked'], null, []) }}
                <div class="col-lg-4">
                </div>
        </div>
    </div>

    <div class="box box-info">
        <div class="box-body">
            <div class="pull-left">
                {{ link_to_route('admin.customers.contacts.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs']) }}
            </div><!--pull-left-->

            <div class="pull-right">
                {{ Form::submit(trans('buttons.general.crud.create'), ['class' => 'btn btn-success btn-md']) }}
            </div><!--pull-right-->

            <div class="clearfix"></div>
        </div><!-- /.box-body -->
    </div><!--box-->
    </div>
    {{ Form::close() }}
@stop

@section('after-scripts')

    <script>
        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';

        $(document).ready(function() {

            $("#type").select2({
                placeholder: "{{ trans('Day', ['field' => trans('general.generalstrings.type')]) }}"
            });

            $("#drivercount").select2({
                placeholder: "{{ trans('validation.attributes.backend.plan.numberofdriver', ['field' => trans('validation.attributes.backend.plan.numberofdriver')]) }}"});


            $("#allowedtask").select2({
                placeholder: "{{ trans('validation.attributes.backend.plan.allowedtask', ['field' => trans('validation.attributes.backend.plan.allowedtask')]) }}"});

            $("#status").select2({
                placeholder: "{{ trans('Status', ['field' => trans('general.generalstrings.status')]) }}"
            });


        });
    </script>

@stop
