 @extends ('backend.layouts.app')
    @section ('title', trans('labels.backend.agents.title') . ' | ' . trans('labels.backend.agents.edit'))
    @section('page-header')
        <h1>
            {{ trans('labels.backend.title.agents.agents') }}
            <small>{{ trans('labels.backend.agents.edit') }}</small>
        </h1>
    @endsection
    @section('content')
        <form method="post" action="{{ route('admin.customers.agents_update')}}">
        {!! csrf_field() !!}
         <div class="box box-success">
            <div class="box-header with-border">
                <h3 class="box-title">{{ trans('labels.backend.agents.edit') }}</h3>
                <div class="box-tools pull-right">
                                    @include('backend.customers.agents.includes.partials.agents-header-buttons')
                </div>
            </div><!-- /.box-header -->
            <div class="box-body">
                {!! csrf_field() !!}
                <div class="row">
                    <div class="col-lg-12">
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                Update
                            </div>
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div role="form">
                                            <div class="form group">
                                                 <input type="hidden" name="id" value="{{$driver->agent_id}}">
                                            </div>
                                            <div class="form group">
                                                <label>First Name</label>
                                                <input class="form-control" name="first_name" value="{{$driver->first_name}}">
                                            </div>
                                            <div class="form group">
                                                <label>Last Name</label>
                                                <input class="form-control" name="last_name" value="{{$driver->last_name}}">
                                            </div>
                                            <div class="form group">
                                                <label>Phone</label>
                                                <input class="form-control" name="phone" value="{{$driver->phone}}">
                                            </div>
                                            <div class="form group">
                                                <label>Address</label>
                                                <input class="form-control" name="location_address" value="{{$driver->location_address}}">
                                            </div>
<!--                                             <div class="form group">
                                                <label>Email Name</label>
                                                <input class="form-control" name="email" value="{{$result->email}}">
                                            </div> -->
                                            <div class="form group">
                                                <!-- <div class="col-lg-12"> -->
                                                    {{ Form::selectGroupFullWidth('transport_type_id', trans('Transport Type'), 'caret-down', ['1' => 'Truck', '2' => 'Car', '3' => 'Bike','4' => 'Bicycle','5' => 'Scooter','6' => 'Walk' ], null, []) }}
                                                </div>
                                                    <div class="form group">
                                                    {{ Form::selectGroupFullWidth('status', trans('status'), 'caret-down', ['1' => 'Active', '2' => 'Pending for Approval', '3' => 'Suspended','4' => 'Blocked' ], null, []) }}
                                                <!-- </div> -->
                                            </div>
                                        </div>
                                        <br><br></div>
                                        <div class="col-lg-6">
                                            <div class="form group">
                                                <label>Transport Description</label>
                                                <input class="form-control" name="transport_description" value="{{$driver->transport_description}}">
                                            </div>
                                            <div class="form group">
                                                <label>Licence Plate</label>
                                                <input class="form-control" name="licence_plate" value="{{$driver->licence_plate}}">
                                            </div>
                                            <div class="form group">
                                                <label>Color</label>
                                                <input class="form-control" name="color" value="{{$driver->color}}">
                                            </div>
<!--                                             <div class="form group">
                                                <label>Password</label>
                                                <input type="password" class="form-control" name="password" value="{{$result->password}}">
                                            </div> -->
                                            
                                            
                                            <div class="form group">
                                                {{ Form::selectGroupFullWidth('team_id', trans('Assign to Team'),'caret-down',$team, null,[]) }}
                                            </div>
                                        </div>
                                    <div class="col-lg-12">
                                    <button type="submit" class="btn btn-success btn-edit">Update</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
         </div>
        </form>
        </div>
    @stop

    @section('after-scripts')

        <script>
            var text_yes = '{{ trans('general.yes') }}';
            var text_no = '{{ trans('general.no') }}';

            $(document).ready(function() {

                $("#status").select2({
                    placeholder: "{{ trans('Status', ['field' => trans('general.generalstrings.type')]) }}"
                });
                $("#transport_type_id").select2({
                    placeholder: "{{ trans('Type', ['field' => trans('Transport Type')]) }}"
                });
                $("#team_id").select2({
                    placeholder: "{{ trans('Type', ['field' => trans('Select Team')]) }}"
                });

            });
        </script>

    @stop