@extends ('backend.layouts.app')


@section ('title', trans('Leads Management') . ' | ' . trans('Verified'))


@section('page-header')

    <h1>

        {{ trans('Leads Management') }}

        <small>{{ trans('') }}</small>

    </h1>

@endsection



@section('content')

    <!-- start -->
    <div class="box box-success">

        <div class="box-header with-border">

            <h3 class="box-title">{{ trans('Details') }}</h3>


            <div class="box-tools pull-right">


            </div><!--box-tools pull-right-->

        </div><!-- /.box-header -->


        <div class="box-body">

            <div class="control-group">

                <div class="col-md-6">


                    <div class="col-md-12">

                        <div class="col-md-12">

                            <div class="table-responsive">

                                <table class="table table-hover" style="margin-top: 10px;">

                                    <tr>

                                        <th>@lang('First Name')</th>

                                        <td>{{ $results->fname }}</td>

                                    </tr>

                                    <tr>

                                        <th>@lang('Last Name')</th>

                                        <td>{{ $results->lname }}</td>

                                    </tr>

                                    <tr>

                                        <th>@lang('Primary Phone')</th>

                                        <td>{{ $results->pphone }}</td>

                                    </tr>

                                    <tr>

                                        <th>@lang('Email')</th>

                                        <td>{{ $results->email }}</td>

                                    </tr>

                                </table>
                            </div>

                        </div>

                    </div><!--table-responsive-->

                </div>

            </div><!-- /.box-body -->

        </div><!--box-->

    </div>
    <!-- end -->
    <div class="box box-success">

        <div class="box-header with-border">

            <h3 class="box-title">{{ trans('Additional Details') }}</h3>


            <div class="box-tools pull-right">


            </div><!--box-tools pull-right-->

        </div><!-- /.box-header -->


        <div class="box-body">

            <div class="control-group">

                <div class="col-md-6">


                    <div class="col-md-12">

                        <div class="col-md-12">

                            <div class="table-responsive">
                                @if($astatus == 0)
                                    <h3 class="box-title">{{ trans('There are no additional details') }}</h3>
                                @else
                                    <table class="table table-hover" style="margin-top: 10px;">

                                        @foreach($leads as $key => $value)

                                            <tr>

                                                <th><?php echo str_replace('_', ' ', $key); ?></th>

                                                <td><?php echo $value; ?></td>

                                            </tr>

                                        @endforeach

                                    </table>
                                @endif
                            </div>

                        </div>

                    </div><!--table-responsive-->

                </div>

            </div><!-- /.box-body -->

        </div><!--box-->

    </div>

    @if($results->isvalidated != 1)

        {{ Form::model($results, ['route' => ['admin.agents.leads.update', $results->id], 'class' => '', 'role' => 'form', 'method' => 'PATCH']) }}

        <div class="box box-info">

            <div class="control-group">

                <div class="col-md-12">

                    <h5>{{ Form::label('isvalidated', trans('This information is valid ?')) }}</h5>

                </div>

            </div>

            <div class="box-body">

                {{ Form::selectGroup('isvalidated', trans('Validated'), 'caret-down', ['1'=>'Valid','0'=>'Invalid'], $results->isvalidated, []) }}

                <div class="clearfix"></div>

            </div><!-- /.box-body -->

        </div><!--box-->

        <div class="box box-info">

            <div class="box-body">

                <div class="pull-left">

                    {{ link_to_route('admin.agents.leads.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}

                </div><!--pull-left-->


                <div class="pull-right">

                    {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-md']) }}

                </div><!--pull-right-->


                <div class="clearfix"></div>

            </div><!-- /.box-body -->

        </div><!--box-->

        {{ Form::close() }}

    @endif

@stop



@section('after-scripts')

    {{ Html::script('js/backend/access/users/script.js') }}

    <script>

        $(document).ready(function () {


            $("#type").select2({

                placeholder: "{{ trans('Day', ['field' => trans('settings.localisation.date.format')]) }}"

            });


            $("#status").select2({

                placeholder: "{{ trans('Status', ['field' => trans('settings.localisation.date.format')]) }}"

            });


        });

    </script>

@stop

