@extends ('backend.layouts.app')
@section ('title', trans('labels.backend.title.agents.agents'))
@section('after-styles')
    {{ Html::style("css/backend/plugin/datatables/dataTables.bootstrap.min.css") }}
@stop
@section('page-header')
{{--    {{dd('okkkk')}}--}}
    <h1>
        {{ trans('labels.backend.title.agents.agents') }}
        <small>{{ trans('labels.backend.title.promo.active') }}</small>
    </h1>
@endsection
@section('content')
    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('labels.backend.title.promo.active') }}</h3>

            <div class="box-tools pull-right">
                @include('backend.agency.agents.includes.partials.agents-header-buttons')
            </div><!--box-tools pull-right-->
        </div><!-- /.box-header -->
        <div class="box-body">
            <div class="table-responsive">
                <table id="agents-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
{{--                        <th>{{ trans('labels.backend.title.agents.table.id') }}</th>--}}
                        <th>{{ trans('First Name') }}</th>
                        <th>{{ trans('Last Name') }}</th>
                        <th>{{ trans('Phone') }}</th>
                        <th>{{ trans('Mobile') }}</th>
                        <th>{{ trans('Email') }}</th>
                        <th>{{ trans('Agency') }}</th>
                        <th>{{ trans('Status') }}</th>
                        <th>{{ trans('Online/Offline') }}</th>
                        <th>{{ trans('labels.general.actions') }}</th>
                    </tr>
                    </thead>
                </table>
            </div><!--table-responsive-->
        </div><!-- /.box-body -->
    </div><!--box-->

@endsection
@section('after-scripts')
    {{ Html::script("js/backend/plugin/datatables/jquery.dataTables.min.js") }}
    {{ Html::script("js/backend/plugin/datatables/dataTables.bootstrap.min.js") }}

    <script>
        $(function() {
            $('#agents-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '{{ route("admin.agency.agents.get") }}',
                    type: 'get'
                },
                columns: [
                    {{--{data: 'id', name: '{{config('ubereat.user_driver_detail')}}.id'},--}}
                    {data: 'first_name', name: '{{config('iceworm.dx_agents')}}.first_name', render: $.fn.dataTable.render.text()},
                    {data: 'last_name', name: '{{config('iceworm.dx_agents')}}.last_name'},
                    {data: 'phone', name: '{{config('iceworm.dx_agents')}}.phone'},
                    {data: 'mobile', name: '{{config('iceworm.dx_agents')}}.mobile'},
                    {data: 'email', name: '{{config('iceworm.dx_agents')}}.email'},
                    {data: 'agency_id', name: '{{config('iceworm.dx_agents')}}.agency_id'},
                    {data: 'status', name: '{{config('iceworm.dx_agents')}}.status'},
                    {data: 'online', name: '{{config('iceworm.dx_agents')}}.online'},
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                order: [[0, "asc"]],
                searchDelay: 100
            });
        });
    </script>
@endsection

