@extends ('backend.layouts.app')

@section ('title', trans('labels.backend.agents.title') . ' | ' . trans('labels.backend.agents.edit'))

@section('page-header')
    <h1>
        {{ trans('labels.backend.title.agents.agents') }}
        <small>{{ trans('labels.backend.agents.edit') }}</small>
    </h1>
@endsection
@section('content')
    {{ Form::model($agent, ['route' => ['admin.agency.agents.update', $agent], 'class' => '', 'role' => 'form', 'method' => 'PATCH']) }}

    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('labels.backend.title.plan.edit') }}</h3>
            <div class="box-tools pull-right">
                @include('backend.superadmin.agents.includes.partials.agents-header-buttons')
            </div>
        </div>
        <div class="box-body">
            <div class="control-group">
                {{ Form::textGroup('first_name', trans('labels.backend.agents.first_name'), 'info', ['placeholder' => trans('labels.backend.agents.first_name')]) }}
                {{ Form::textGroup('last_name', trans('labels.backend.agents.last_name'), 'info', ['placeholder' => trans('labels.backend.agents.last_name')]) }}
                {{ Form::textGroup('email', trans('labels.backend.agents.email'), 'envelope', ['placeholder' => trans('labels.backend.agents.email')]) }}
                {{ Form::textGroup('mobile', trans('Mobile'), 'envelope', ['placeholder' => trans('Mobile')]) }}
                {{ Form::textGroup('phone', trans('labels.backend.agents.phone'), 'phone', ['placeholder' => trans('labels.backend.agents.phone')]) }}
                {{ Form::selectGroup('status', trans('validation.attributes.backend.plan.status'), 'caret-down', ['1'=>'Active','0'=>'Deactivate'],  $agent->status, []) }}
                {{ Form::selectGroup('online', trans('Online/Offline'), 'caret-down', ['1'=>'Online','0'=>'Offline'],  $online->online, []) }}
                {{ Form::selectGroup('country', trans('Country'), 'flag', $countries, null, []) }}
                <div class="col-md-6">
                    <label for="city">{{ trans('City') }}</label>
                    <select name="city_id" id="city" class="form-control">
                        @foreach($city as $citi)
                            @if($citi->id == $agent->city_id)
                                <option selected value="{{$citi->id}}">{{$citi->city}}</option>
                            @else
                                <option value="{{$citi->id}}">{{$citi->city}}</option>
                            @endif
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
    </div>
    <div class="box box-info">
        <div class="box-body">
            <div class="pull-left">
                {{ link_to_route('admin.superadmin.agents.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
            </div>
            <div class="pull-right">
                {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-md']) }}
            </div>
            <div class="clearfix"></div>
        </div>
    </div>
    {{ Form::close() }}
@stop
@section('after-scripts')

    <link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">
    <script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>

    <script>
        $(function () {
            $('#country').on('change', function () {
                console.log($(this).val());
                var id = $(this).val();
                $.ajax({
                    method: "GET",
                    url: '{{url('admin/superadmin/cityget') }}' + '/' + id
                }).done(function (data) {
                    $('#city').html(data.html);
                });
            });
        });
    </script>

    <script>

        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';
        $(document).ready(function () {
            $("#status").select2({
                placeholder: "{{ trans('Status', ['field' => trans('general.generalstrings.type')]) }}"
            });
            $("#transport_type_id").select2({
                placeholder: "{{ trans('Type', ['field' => trans('Transport Type')]) }}"
            });
            $("#team_id").select2({
                placeholder: "{{ trans('Type', ['field' => trans('Select Team')]) }}"
            });
        });
    </script>
@stop