@extends ('backend.layouts.app')

@section ('title', trans('labels.backend.agents.title') . ' | ' . trans('labels.backend.agents.create'))

@section('page-header')
    <h1>
        {{ trans('labels.backend.title.agents.agents') }}
        <small>{{ trans('labels.backend.agents.create') }}</small>
    </h1>
@endsection

@section('content')

    {{ Form::open(['route' => 'admin.agency.agents.store', 'class' => '', 'role' => 'form', 'method' => 'post' , 'enctype' => 'multipart/form-data']) }}
    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('labels.backend.agents.create') }}</h3>
            <div class="box-tools pull-right">
                @include('backend.superadmin.agents.includes.partials.agents-header-buttons')
            </div>
        </div><!-- /.box-header -->
        <div class="box-body">
            <div class="control-group">
                {{ Form::textGroup('first_name', trans('labels.backend.agents.first_name'), 'info', ['placeholder' => trans('labels.backend.agents.first_name')]) }}
                {{ Form::textGroup('last_name', trans('labels.backend.agents.last_name'), 'info', ['placeholder' => trans('labels.backend.agents.last_name')]) }}
                {{ Form::textGroup('email', trans('labels.backend.agents.email'), 'envelope', ['placeholder' => trans('labels.backend.agents.email')]) }}
                {{ Form::passwordGroup('password', trans('Password'), 'key', ['placeholder' => trans('password')]) }}
                {{ Form::textGroup('mobile', trans('Mobile'), 'mobile', ['placeholder' => trans('Mobile')]) }}
                {{ Form::textGroup('phone', trans('labels.backend.agents.phone'), 'phone', ['placeholder' => trans('labels.backend.agents.phone')]) }}
                {{ Form::selectGroup('country', trans('validation.attributes.backend.settings.country'), 'flag', $countries, null, []) }}
                <div class="col-md-6" style="margin-top: 25px;">
                    <select name="city_id" id="city" class="form-control">
                        <option value="">{{ trans('Please Select') }}</option>
                    </select>
                </div>
            </div><!--form control-->
        </div><!-- /.box-body -->
    </div><!--box-->
    <div class="box box-info">
        <div class="box-body">
            <div class="pull-left">
                {{ link_to_route('admin.agency.agents.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
            </div><!--pull-left-->
            <div class="pull-right">
                {{ Form::submit(trans('buttons.general.crud.create'), ['class' => 'btn btn-success btn-md']) }}
            </div><!--pull-right-->
            <div class="clearfix"></div>
        </div><!-- /.box-body -->
    </div><!--box-->
    {{ Form::close() }}

@stop



@section('after-scripts')

    <script>
        $(function () {
            $('#country').on('change', function () {
                console.log($(this).val());
                var id = $(this).val();
                $.ajax({
                    method: "GET",
                    url: '{{url('admin/superadmin/cityget') }}' + '/' + id
                }).done(function (data) {
                    $('#city').html(data.html);
                });
            });
        });
    </script>

    <script>

        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';

        $(document).ready(function () {
            $("#status").select2({
                placeholder: "{{ trans('Status', ['field' => trans('general.generalstrings.type')]) }}"
            });
            $("#transport_type_id").select2({
                placeholder: "{{ trans('Transport Type', ['field' => trans('Transport Type')]) }}"
            });
            $("#team_id").select2({
                placeholder: "{{ trans('Select Team', ['field' => trans('Select Team')]) }}"
            });
        });
    </script>
@stop