<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted'             => 'The :attribute must be accepted.',
    'active_url'           => 'The :attribute is not a valid URL.',
    'after'                => 'The :attribute must be a date after :date.',
    'after_or_equal'       => 'The :attribute must be a date after or equal to :date.',
    'alpha'                => 'The :attribute may only contain letters.',
    'alpha_dash'           => 'The :attribute may only contain letters, numbers, and dashes.',
    'alpha_num'            => 'The :attribute may only contain letters and numbers.',
    'array'                => 'The :attribute must be an array.',
    'before'               => 'The :attribute must be a date before :date.',
    'before_or_equal'      => 'The :attribute must be a date before or equal to :date.',
    'between'              => [
        'numeric' => 'The :attribute must be between :min and :max.',
        'file'    => 'The :attribute must be between :min and :max kilobytes.',
        'string'  => 'The :attribute must be between :min and :max characters.',
        'array'   => 'The :attribute must have between :min and :max items.',
    ],
    'boolean'              => 'The :attribute field must be true or false.',
    'confirmed'            => 'The :attribute confirmation does not match.',
    'date'                 => 'The :attribute is not a valid date.',
    'date_format'          => 'The :attribute does not match the format :format.',
    'different'            => 'The :attribute and :other must be different.',
    'digits'               => 'The :attribute must be :digits digits.',
    'digits_between'       => 'The :attribute must be between :min and :max digits.',
    'dimensions'           => 'The :attribute has invalid image dimensions.',
    'distinct'             => 'The :attribute field has a duplicate value.',
    'email'                => 'The :attribute must be a valid email address.',
    'exists'               => 'The selected :attribute is invalid.',
    'file'                 => 'The :attribute must be a file.',
    'filled'               => 'The :attribute field must have a value.',
    'image'                => 'The :attribute must be an image.',
    'in'                   => 'The selected :attribute is invalid.',
    'in_array'             => 'The :attribute field does not exist in :other.',
    'integer'              => 'The :attribute must be an integer.',
    'ip'                   => 'The :attribute must be a valid IP address.',
    'ipv4'                 => 'The :attribute must be a valid IPv4 address.',
    'ipv6'                 => 'The :attribute must be a valid IPv6 address.',
    'json'                 => 'The :attribute must be a valid JSON string.',
    'max'                  => [
        'numeric' => 'The :attribute may not be greater than :max.',
        'file'    => 'The :attribute may not be greater than :max kilobytes.',
        'string'  => 'The :attribute may not be greater than :max characters.',
        'array'   => 'The :attribute may not have more than :max items.',
    ],
    'mimes'                => 'The :attribute must be a file of type: :values.',
    'mimetypes'            => 'The :attribute must be a file of type: :values.',
    'min'                  => [
        'numeric' => 'The :attribute must be at least :min.',
        'file'    => 'The :attribute must be at least :min kilobytes.',
        'string'  => 'The :attribute must be at least :min characters.',
        'array'   => 'The :attribute must have at least :min items.',
    ],
    'not_in'               => 'The selected :attribute is invalid.',
    'numeric'              => 'The :attribute must be a number.',
    'present'              => 'The :attribute field must be present.',
    'regex'                => 'The :attribute format is invalid.',
    'required'             => 'The :attribute field is required.',
    'required_if'          => 'The :attribute field is required when :other is :value.',
    'required_unless'      => 'The :attribute field is required unless :other is in :values.',
    'required_with'        => 'The :attribute field is required when :values is present.',
    'required_with_all'    => 'The :attribute field is required when :values is present.',
    'required_without'     => 'The :attribute field is required when :values is not present.',
    'required_without_all' => 'The :attribute field is required when none of :values are present.',
    'same'                 => 'The :attribute and :other must match.',
    'size'                 => [
        'numeric' => 'The :attribute must be :size.',
        'file'    => 'The :attribute must be :size kilobytes.',
        'string'  => 'The :attribute must be :size characters.',
        'array'   => 'The :attribute must contain :size items.',
    ],
    'string'               => 'The :attribute must be a string.',
    'timezone'             => 'The :attribute must be a valid zone.',
    'unique'               => 'The :attribute has already been taken.',
    'uploaded'             => 'The :attribute failed to upload.',
    'url'                  => 'The :attribute format is invalid.',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap attribute place-holders
    | with something more reader friendly such as E-Mail Address instead
    | of "email". This simply helps us make messages a little cleaner.
    |
    */

    'attributes' => [

        'backend' => [

            'reports'=>[
                'name' => ' Select Agent Name',
            ],

            'to'=>[
                'to'=>'To',
                'placehold'     =>'e.g. +1 201 241 2160',
                'message'       =>'Write Message',
                'placeholder'   =>'e.g. Hi ! How are you ',
            ],

            'notification'=>[
                'mobile_push'               =>'Mobile Push',
                'sms'                       =>'SMS',
                'email'                     =>'Email',
                'task_created_mobile_push'  =>'',
                'tags'                      =>'Available Tags',

            ],

            'services'=>[
                'head_line'     =>'Check the services that you offered',
                'head_linee'    =>'Check the services that you offered',
            ],

            'upload_tasks'=>[
                'headline'          =>'Upload your mass task using csv formatted data',
                'csv'               =>'CSV',
                'bottom_line'       =>' CSV format : trans_type,task_description,contact_number,email_address,
                                       customer_name,delivery_date,delivery_address,task_lat,task_lng
                                       task_lat and task_lng is optional ',
            ],

            'send_bulk'=>[
                'team'              =>'Select Team',
                'push_title'        =>'Push Title',
                'push_message'      =>'Push Message',
            ],
            'assignment'=>[
                'head_line'                 =>'Automatically assign the tasks to your driver and choose from various auto assignment options like one by one and send to all.',
                'enabled_auto_assignment'   =>'Enabled Auto Assignment',
                'offline_driver'            =>'Include Offline Driver',
                'notify_email'              =>'Notify Email',
                'notify_email_heading'      =>'Email address that will receive email if unable to auto assign.',
                'request_expire'            =>'Request Expire',
                'request_exp'               =>'Default is 1 min',
                'auto_retry_assignment'     =>'Auto Retry Assignment',
                'form_end_line'             =>'This will send the task notification to all the Agent at once and will be assigned to Agent who accepts it first.',
                'sending_option2'           =>'2',
                'sending_option1'           =>'1',
            ],
            'tasks'=>[
                'customer_number'       =>'Customer Number',
                'restaurant_name'       =>'Customer Name',
                'datepicker'            =>'Date',
                'select_date'           =>'Select Date',
                'select_team'           =>'Select Team',
                'delivery_address'      =>'Delivery Address',
                'name'                  =>'Name',
                'contacts_number'       =>'Contact Number',
                'address'               =>'Address',
                'pickup_details'        =>'Pickup Details',
                'task_description'      =>'Task Description',
                'cus_name'              =>'Pickup Details',
            ],
            'contacts'=>[
                'fullname'              =>'Name',
                'email'                 =>'Email',
                'phone'                 =>'Phone',
                'address'               =>'Address',
                'status'                =>'Status',
                'state'                 =>"State"
            ],
            'language'=>[
                'tick_the_language_to_enabled'      =>'Tick the language to enabled',
                'lang'                              =>'App Default Language',
                'force_default_language'            =>'Force default language',
            ],
            'services'=>[
              'services_name'           => 'Services Name',
                'parentservices'        => 'Parent Services',
                'description'           => 'Description',
                'status'                => 'Status',
                'parent'                => 'Select Parent Services',
            ],
            'templates'=>[
                'subject'               =>'Subject',
                'welcome_template'      =>'Welcome Template',
                'approved_template'     =>'Approved Template',
                'template'              =>'Template',
                'signup_verification'   =>'Signup Verification',
            ],
            'cmspages'=>[
                'page_name'         =>'Page Name',
                'page_slug'         =>'Slug',
                'page_title'        =>'Title',
                'page_status'       =>'Status',
                'page_content'      =>'Page Content',
                'description'       =>'Description',

            ],
            'sms'=>[
                'twilio'            =>'Twilio',
                'nexmo'             =>'Nexmo',
                'sender_id'         =>'Sender ID',
                'account_sid'       =>'Account SID',
                'auth_token'        =>'AUTH Token',
                'sender'            =>'Sender',
                'use_curl'          =>'Use CURL ?',
                'use_unicode'       =>'Use Unicode ?',
                'key'               =>'Key',
                'secret'            =>'Secret',

            ],
            'settings'=>[
                'company_name'                      =>'Company Name',
                'company_address'                   =>'Company Address',
                'contact_no'                        =>'Contact No',
                'email'                             =>'Email',
                'custom_footer'                     =>'Custom Footer',
                'use_php_mail'                      =>'Use php Mail',
                'use_smtp'                          =>'Use SMTP',
                'email_global_sender'               =>'Email Global Sender',
                'api_key'                           =>'API Key',
                'push_api_key'                      =>'Push API Key',
                'facebook'                          =>'Facebook',
                'google'                            =>'Google',
                'twitter'                           =>'Twitter',
                'enable_signup_verification'        =>'Enable Signup Verification',
                'signup_needs_admin_approval'       =>'Signup Needs Admin Approval',
                'use_email'                         =>'Use Email',
                'use_sms'                           =>'Use SMS',
                'timezone'                          =>'Timezone',
                'default_currency'                  =>'Default Currency',
                'decimal_places'                    =>'Decimal Places',
                'thousand_separators'               =>'Thousand Separators',
                'decimal_separators'                =>'Decimal Separators',
                'add_space_between_currency&price'  =>'Add Space between Currency and price',
                'enable_promo_code'                 =>'Enable Promo Code',
                'currency_position'                 =>'Currency Position',
                'country'                           =>'Default Country',
                'city'                              =>'Default Country',
                'mobile_api_key'                    =>'Your Mobile API Key',
                'push_api_key'                      =>'Push API Key',
                'ios_push_mode'                     =>'iOS Push Mode',
                'push_certificate_pass'             =>'IOS Push Certificate PassPhrase',
                'development'                       =>'Development',
                'production'                        =>'Production',
                'upload_logo'                       =>'Upload Logo',
                'with_sms_notification'             =>'With SMS Notification',
                'with_push_broadcast'               =>'With Push Broadcast',
                'change_language'                   =>'Change Language',
                'send'                              =>'Push Only to Online Driver',
                'disabled'                          =>'Disabled Contact List in AddTask',
                'app_settings'                      =>'App Settings',
                'enabled_notes'                     =>'Enabled Notes',
                'enabled_signature'                 =>'Enabled Signature',
                'enabled_add'                       =>'Enabled Add Photo/Take Picture',
                'enabled_resize_picture'            =>'Enabled Resize Picture',
                'image_resize'                      =>'Image Resize',
                'resize'                            =>'Resize picture during taking picture in the app',
                'width'                             =>'Width',
                'height'                            =>'Height',
                'device_vibration'                  =>'Device Vibration',
                'localize_calendar'                 =>'Localize Calendar',
                'language'                          =>'Language',
                'agents_tracking_options'           =>'Agents Tracking Options',
                'tracking_option_1'                 =>'Tracking Option 1',
                'resize_picture'                    =>'Resize Picture during taking picture in the app',
                'this_options'                      =>'This Options will set the agents only offline when they logout to',
                'the_app'                           =>'the app or set to off duty and idle for more than 30min',
                'records_agents_location'           =>'Records Agents Location',
                'disabled_background_tracking'      =>'Disabled Background Tracking',
                'this_will'                         =>'This will save agents locations for later review',
                'this_options_will'                 =>'this options will not track your agents when the',
                'app_is'                            =>'app is running in background',
                'in_seconds'                        =>'in seconds, Default is 8 seconds',
                'track_interval'                    =>'Track Interval',
                'task_critical_options'             =>'Task Critical Options',
                'set_critical'                      =>'set critical background to the task when its unassigned after a set of minutes',
                'enabled'                           =>'Enabled',
                'default_is_5_minutes'              =>'Default is 5 Minutes',
                'include_offline_driver_on_map'     =>'Include Offline Driver on Map',
                'hide_pickup_task'                  =>'Hide Pickup Task',
                'hide_delivery_task'                =>'Hide Delivery Task',
                'hide_successful_task'              =>'Hide Successful Task',
                'disabled_map_auto_refresh'         =>'Disabled Map Auto Refresh',
                'map_style'                         =>'Map Style',
                'lable_after_map_style'             =>'Set the style of your map. get it on https://snazzymaps.com leave it empty if if you are unsure. ',
                'minutes'                           =>'Minutes',
                'default_3000'                      =>'Default is 3000 Vibrate for 3 seconds',

            ],
            'payment-gateway'=>[
                'enable'                    =>'Enable Paypal',
                'sanbox'                    =>'Sanbox ?',
                'live'                      =>'Live ?',
                'sandbox'                   =>'Sandbox',
                'paypal_user'               =>'Paypal User',
                'paypal_pass'               =>'Paypal Password',
                'paypal_signature'          =>'Paypal Signature',
                'live1'                     =>'Live',
                'stripe_enable'             =>'Enable Stripe',
                'test_secret_key'           =>'Test Secret Key',
                'test_publishable_key'      =>'Test Publishable Key',
                'enable_mercadopago'        =>'Enable Mercadopago',
                'client_id'                 =>'Client ID',
                'client_secret'             =>'Client Secret',
                'enable_razorpay'           =>'Enable RAzorPay',
                'key_id'                    =>'Key ID',
                'key_secret'                =>'Key Secret',
                'enable_authorized'         =>'Enable',
                'api_login-id'              =>'API Login ID',
                'transaction_key'           =>'Transaction Key',
                'sandbox'                   =>'Sandbox',
            ],
            'seo'=>[
                'seo_title'             =>'SEO Title',
                'meta_description'      =>'Meta Description',
                'price_page_seo'        =>'Price Page Seo',
                'title'                 =>'SEO Title',
                'keywords'              =>'Keywords',
            ],
            'smsgateway'=>[
                'twilio'        =>'Twilio',
                'nexmo'         =>'Nexmo',
                'curl'          =>'Use CURL',
                'unicode'       =>'Use Unicode',
                'sender_id'     =>'Sender ID',
                'account_sid'   =>'Account SID',
                'auth_token'    =>'Auth Token',
                'sender'        =>'Sender',
                'key'           =>'Key',
                'secret'        =>'Secret',
                'sender-id'     =>'Sender ID',
            ],
            'currency'=>[
                'currency_code'     =>'Currency Code',
                'currency_symbol'   =>'Currency Symbol',
                'status'            =>'Status',
            ],
            'promo'=>[
                'promo_code'        =>'Promo Code',
                'type'              =>'Type',
	            'day'               =>'Day',
                'status'            =>'Status',
                'expiry'            =>'Expiration',
                'discount'          =>'Discount',
            ],
            'plan'=>[
                'plan_name'         =>'Plan Name',
                'description'       =>'Description',
                'type'              =>'Type',
                'price'             =>'Price',
	            'expiry'            =>'Expiration for number of Days/Month/Year',
	            'expire'            =>'Expiration Details',
	            'promoprice'        =>'Promo Price',
                'status'            =>'Status',
	            'numberofdriver'    =>'Number of allowed driver',
	            'allowedtask'       =>'Number of allowed task',
	            'sms'               =>'SMS Limit',
            ],
            'page'=>[
                'slug'          =>'Slug',
                'page_title'    =>'Page Title',
                'status'        =>'Status',
                'created_at'    =>'Created At',
            ],
            'access' => [
                'permissions' => [
                    'associated_roles' => 'Associated Roles',
                    'dependencies'     => 'Dependencies',
                    'display_name'     => 'Display Name',
                    'group'            => 'Group',
                    'group_sort'       => 'Group Sort',

                    'groups' => [
                        'name' => 'Group Name',
                    ],

                    'name'       => 'Name',
                    'first_name' => 'First Name',
                    'last_name'  => 'Last Name',
                    'system'     => 'System',
                ],

                'roles' => [
                    'associated_permissions' => 'Associated Permissions',
                    'name'                   => 'Name',
                    'sort'                   => 'Sort',
                ],

                'users' => [
                    'active'                  => 'Active',
                    'associated_roles'        => 'Associated Roles',
                    'confirmed'               => 'Confirmed',
                    'email'                   => 'E-mail Address',
                    'name'                    => 'Name',
                    'last_name'               => 'Last Name',
                    'first_name'              => 'First Name',
                    'other_permissions'       => 'Other Permissions',
                    'password'                => 'Password',
                    'password_confirmation'   => 'Password Confirmation',
                    'send_confirmation_email' => 'Send Confirmation E-mail',
                ],
            ],
        ],

        'frontend' => [
            'email'                     => 'E-mail Address',
            'first_name'                => 'First Name',
            'last_name'                 => 'Last Name',
            'name'                      => 'Full Name',
            'password'                  => 'Password',
            'password_confirmation'     => 'Password Confirmation',
            'phone'                     => 'Phone',
            'message'                   => 'Message',
            'new_password'              => 'New Password',
            'new_password_confirmation' => 'New Password Confirmation',
            'old_password'              => 'Old Password',
        ],
    ],

];
