
/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

require('./bootstrap');

window.Vue = require('vue');

/**
 * Next, we will create a fresh Vue application instance and attach it to
 * the page. Then, you may begin adding components to this application
 * or customize the JavaScript scaffolding to fit your unique needs.
 */

// This is a global mixin, it is applied to every vue instance
Vue.mixin({
    data: function() {
        var url = window.location.href;
        var final_url = url.split('admin', 2);
        
        return {
            globalVar: final_url[0]
        }
    }
});

Vue.component('chat-app', require('./components/ChatApp.vue'));

const app = new Vue({
    el: '#app'
});
