<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCityTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('dx_cities', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->string('country_id')->references('id')->on('dx_countries');
            $table->string('state_id')->references('id')->on('dx_states');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dx_cities');
    }
}
