<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class Country extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('dx_countries', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->string('web_code');
            $table->string('local_name');
            $table->enum('continent', ['Asia','Europe','North America','Africa','Oceania','Antarctica','South America']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dx_countries');
    }
}
