<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLeadsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('leads', function (Blueprint $table) {
            $table->increments('id');
            $table->string('fname')->nullable();
            $table->string('lname')->nullable();
            $table->string('pphone')->nullable();
            $table->string('sphone')->nullable();
            $table->string('email')->nullable();
            $table->string('address')->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('zip')->nullable();
            $table->string('gender')->nullable();
            $table->string('birthdate')->nullable();
            $table->string('age')->nullable();
            $table->string('self_assessed_credit')->nullable();
            $table->string('home_type')->nullable();
            $table->string('year_built')->nullable();
            $table->string('square_feet')->nullable();
            $table->string('bedrooms')->nullable();
            $table->string('bathrooms')->nullable();
            $table->string('construction_type')->nullable();
            $table->string('roof_surface')->nullable();
            $table->string('foundation_type')->nullable();
            $table->string('exterior_walls')->nullable();
            $table->string('garage_type')->nullable();
            $table->string('total_stories')->nullable();
            $table->string('electrical_system')->nullable();
            $table->string('fireplaces')->nullable();
            $table->string('pool')->nullable();
            $table->string('patio_deck')->nullable();
            $table->string('alarm')->nullable();
            $table->string('central_ac')->nullable();
            $table->string('dead_bolt')->nullable();
            $table->string('smoke_detector')->nullable();
            $table->string('fire_extinguisher')->nullable();
            $table->string('smoker_in_home')->nullable();
            $table->string('dog_in_home')->nullable();
            $table->string('near_fire_station')->nullable();
            $table->string('near_fire_hydrant')->nullable();
            $table->string('currently_insured')->nullable();
            $table->string('current_carrier')->nullable();
            $table->string('residence_coverage_amount')->nullable();
            $table->string('personal_property_amount')->nullable();
            $table->string('personal_liability_amount')->nullable();
            $table->string('deductible_amount')->nullable();
            $table->string('years_continuously_covered')->nullable();
            $table->string('policy_expiration')->nullable();
            $table->string('property_address')->nullable();
            $table->string('property_city')->nullable();
            $table->string('property_state')->nullable();
            $table->string('property_zip')->nullable();
            $table->string('property_use')->nullable();
            $table->string('home_value')->nullable();
            $table->string('isverfied')->nullable();
            $table->string('isvalidated')->nullable();
            $table->integer('transferto')->nullable();
            $table->boolean('status')->default(false ? false : true);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop("leads");
    }
}
