<?php

namespace App\Repositories\Backend\Superadmin;

use App\Models\Superadmin\Setting\Setting;
use App\Repositories\BaseRepository;

class SettingsRepository extends BaseRepository
{
    /*
     * @return $this
     */
    protected $time=0;

    public function getControl($options)
    {

        $optionsFields = array();
        $time=0;
        //$time=0;
        foreach($options as $option)
        {
            $fieldHtml="";
            /*if($option->heading != '' || $option->heading != null )
            {
                $fieldHtml .= "<h2 class='admin-heading bottom-20'>".title_case($option->heading)."</h2>";
            }*/
            if($option->heading != '' || $option->heading != null ) {

                if ($time >= 1) {
                    $fieldHtml .="</div>
                            </div>
                        </div>";
                }
                $this->time++;
                $time++;

                $fieldHtml .= "
                                   
						<div class='card' >
                            <div class='card-header' role='tab' id='heading".$option->id.$this->time."'>
                                <a class='' data-toggle='collapse' ".($time <= 1 ? 'aria-expanded=true': '')." data-parent='#accordion' href='#collapse".$option->id.$this->time."'  aria-controls='collapse".$option->id.$this->time."'>
                                    <h5>" . title_case( $option->heading ) . "<i class='fa fa-angle-down rotate-icon pull-right'></i></h5>
                                </a>
                            </div>
                            <div id='collapse".$option->id.$this->time."' class='collapse row' role='tabpanel' aria-labelledby='heading".$option->id.$this->time."'>
                                        <div class='card-block'>
                            ";

            }
            if($option->control_type=="radio")
            {
                $selected="";
                $itemValues=json_decode($option->control_default_value);
                foreach($itemValues as $item)
                {
                    if(isset($option->key_name) && $option->key_name!="")
                    {
                        if($item->key==$option->key_value)
                            $selected="checked=checked";
                        else
                            $selected="";
                    }
                    $fieldHtml.="<label for='$option->key_name'  class='col-lg-1 control-label' >$item->key</label><div class='col-lg-10'><div class='col-lg-1'><input type='radio' name='$option->key_name' class='' $selected value='$item->key'  /></div></div>";
                }

                $fieldHtml .= "<h5 class='col-md-12 top15'>$option->sub_heading</h5>";
                $optionsFields[]=$fieldHtml;


            }
            elseif($option->control_type=="textbox")
            {

                $itemValues=json_decode($option->control_default_value);
                foreach($itemValues as $item)
                {
                    if(isset($option->key_name) && $option->key_value!="")
                    {

                        $fieldHtml.="<label for='$option->key_name'  class='pull-left col-lg-2 control-label'>$option->key_name </label><div class='col-md-10'><input name=".str_slug($option->key_name, '_')."  type='text' class='form-control' value='$option->key_value' placeholder='$item->key'  /></div>";
                    }
                    else
                    {
                        $fieldHtml.="<label for='$option->key_name'  class=' pull-left col-lg-2 control-label'>$option->key_name </label><div class='col-md-10'><input name=".str_slug($option->key_name, '_')."  type='text' class='form-control' value='' placeholder='$item->key'  /></div>";
                    }

                }
                $fieldHtml .= "<h5 class='col-md-12 top15'>$option->sub_heading</h5>";
                $optionsFields[]=$fieldHtml;

            }
            elseif($option->control_type=="select")
            {
                $itemValues=json_decode($option->control_default_value);
                $selected="";
                $fieldHtml.="<label  for='$option->key_name'  class=' col-lg-2 control-label'>$option->key_name</label><div class='col-md-10'><select name=".str_slug($option->key_name, '_')." class='form-control select2 col-md-10'>";
                foreach($itemValues as $item)
                {
                    if(isset($option->key_name) && $option->key_name!="")
                    {
                        if($item->key==$option->key_value)
                            $selected="selected=selected";
                        else
                            $selected="";
                    }
                    $fieldHtml.="<option $selected value='$item->key'>$item->key</option>";

                }
                $fieldHtml.="</select></div>";
                $fieldHtml .= "<h5 class='top15'>$option->sub_heading</h5>";
                $optionsFields[]=$fieldHtml;
            }
            elseif($option->control_type=="checkbox")
            {
                $selected="";
                $itemValues=json_decode($option->control_default_value);
                foreach($itemValues as $item)
                {
                    if(isset($option->key_name) && $option->key_value!="")
                    {
                        if($item->key==$option->key_value)
                            $selected="checked=checked";
                        else
                            $selected="";
                    }
                    $fieldHtml.="<label class='col-md-12 control-label'style='padding-left: 0'><span class='col-lg-2' style='padding-right: 0'>$option->key_name</span><div class='col-md-4'><input name=".str_slug($option->key_name, '_')." type='checkbox' $selected class='' value='$item->key'  /></div></label>";
                }
                $fieldHtml .= "<h5 class='col-md-12 top15'>$option->sub_heading</h5>";
                $optionsFields[]=$fieldHtml;
            }
            elseif($option->control_type=="file")
            {

                if(isset($option->key_name) && $option->key_value!="")
                {
                    // $fieldHtml.="<label for='$option->key_name'  class='col-lg-2 control-label'>$option->key_name</label><div class='col-lg-10 applyDropZone'><input name=".str_slug($option->key_name, '_')." type='file'  class='col-md-5 applyDropZone'  /> <img src=".asset($option->key_value)." class='col-md-4 img-responsive' style='height:150px;width:200px;object-fit:cover'></div>";
                    $fieldHtml.="<label for='$option->key_name'  class='col-lg-2 control-label'>$option->key_name</label>
									<div class='col-lg-10 applyDropZone' id='".str_slug($option->key_name, '_')."'>
				                    <div class='col-md-5   dropZonePicker'>
				                    <span class='text text-success'>Chose/Drag image </span>
									<input name=".str_slug($option->key_name, '_')." type='file'  class='hidden'  />
									<input name=".str_slug($option->key_name, '_')." id=".str_slug($option->key_name, '_')." type='hidden'  class='hidden'  />
									</div>
									 <div class='col-md-4 imagePreview'> 
									 <img src=".asset($option->key_value)." class='img-responsive thumbnail' >
									 </div>
									 </div>";
                }
                else
                {
                    $fieldHtml.="<label for='$option->key_name'  class='col-lg-2 control-label'>$option->key_name</label>
								<div class='col-lg-10 applyDropZone' id='".str_slug($option->key_name, '_')."'>
								<div class='col-md-5 dropZonePicker'>
								<span class='text text-success'>Chose/Drag image </span>
								<input name=".str_slug($option->key_name, '_')." type='file' src='' class='hidden'  />
								<input name=".str_slug($option->key_name, '_')." id=".str_slug($option->key_name, '_')." type='hidden'  class='hidden'  />
								</div>
								<div class='col-md-4 imagePreview' > 
								</div>
								</div>";
                }
                $fieldHtml .= "<h5 class='col-md-12 top15'>$option->sub_heading</h5>";
                $optionsFields[]=$fieldHtml;
            }
            elseif($option->control_type=="textarea")
            {
                $itemValues=json_decode($option->control_default_value);
                foreach($itemValues as $item)
                {
                    if(isset($option->key_name) && $option->key_value!="")
                    {
                        $fieldHtml.="<label for='$option->key_name' class='col-lg-2 control-label'>$option->key_name </label><div class='col-md-10'><textarea rows='5' class='form-control' name=".str_slug($option->key_name, '_').">$option->key_value</textarea></div> ";
                    }
                    else
                    {
                        $fieldHtml.="<label for='$option->key_name' class='col-lg-2 control-label'>$option->key_name </label><div class='col-md-10'><textarea rows='5' class='form-control' name=".str_slug($option->key_name, '_')." placeholder='$item->key'></textarea></div> ";
                    }

                }
                $fieldHtml .= "<h5 class='col-md-12 top15'>$option->sub_heading</h5>";
                $optionsFields[]=$fieldHtml;
            }

        }
        $optionsFields[]="</div>
                            </div>
                        </div>";
        return  $optionsFields;

    }

    public function saveSetting($request)
    {
        $options = Settings::all();
        foreach ($options as $option)
        {

            if ($option->control_type=="file")
            {

                if($request->hasFile(str_slug($option->key_name, '_')))
                {

                    $image_name = $request->file(str_slug($option->key_name, '_'))->getClientOriginalName().".".$request->file(str_slug($option->key_name, '_'))->getClientOriginalExtension();
                    while(\File::exists(public_path("img/backend/uploads/setting/".$image_name)))
                        $image_name = $request->file(str_slug($option->key_name, '_'))->getClientOriginalName()."-".str_random(3).".".$request->file(str_slug($option->key_name, '_'))->getClientOriginalExtension();
                    $request->file(str_slug($option->key_name, '_'))->move(public_path("img/backend/uploads/setting"), $image_name);


                    $option->key_value = "img/backend/uploads/setting/".$image_name;
                    $option->save();
                }elseif($request->has(str_slug($option->key_name, '_'))){
                    $a = str_slug($option->key_name, '_');
                    $option->key_value = $request->$a;
                    $option->save();
                }

            }
            elseif ($option->control_type=="checkbox"){
                $a=str_slug($option->key_name, '_');


                if ($request->$a == null){

                    $option->key_value='';
                }else {


                    $option->key_value =$request->$a;
                }
                $option->save();
            }
            else
            {
                if($request->has(str_slug($option->key_name, '_')))
                {
                    $option->key_value = $request->get(str_slug($option->key_name, '_'));
                    $option->save();
                }
            }

        }
        return true;
    }
}
