<?php

namespace App\Repositories\Backend\Superadmin;



use App\Models\Superadmin\Currency\Currency;
use App\Repositories\BaseRepository;
use DB;
use App\Exceptions\GeneralException;
use Illuminate\Database\Eloquent\Model;


/**
 * Class UserRepository
 * @currency App\Repositories\User
 */
class CurrencyRepository extends BaseRepository
{
    /**
     * Associated Repository Model
     */
    const MODEL = Currency::class;

    /**
     * @var RoleRepository
     */

    public function __construct()
    {

        //$this->role = $role;
    }

    /**
     * @param int $status
     * @param bool $trashed
     * @return mixed
     */
    public function getForDataTable($status = 1, $trashed = false)
    {
        /**
         * Note: You must return deleted_at or the User getActionButtonsAttribute won't
         * be able to differentiate what buttons to show for each row.
         */
        //dd(DB::table('ta_currency')->get());
        $dataTableQuery = $this->query()

            ->select([
                config('ubereat.currencies') . '.id',
                config('ubereat.currencies') . '.currency_code',
                config('ubereat.currencies') . '.amount',
                config('ubereat.currencies') . '.agency_id',
                config('ubereat.currencies') . '.created_at',
                config('ubereat.currencies') . '.updated_at',
                config('ubereat.currencies') . '.deleted_at',
            ]);

        if ($trashed == "true") {
            return $dataTableQuery->onlyTrashed();
        }

        // active() is a scope on the UserScope trait
        return $dataTableQuery;
    }

    /**
     * @param Model $input
     */
    public function create($input)
    {
        $data = $input['data'];


        $currency = $this->createUserStub($data);

        DB::transaction(function() use ($currency, $data) {
            if ($currency->save()) {

            //            if (parent::save($currency)) {





                //event(new UserCreated($currency));
                return true;
            }

            throw new GeneralException(trans('exceptions.backend.takeaway.currency.create_error'));
        });
    }

    /**
     * @param Model $user
     * @param array $input
     */
//    public function update(Model $currency, array $input)
//    {
//        $data = $input['data']->all();
//
//
//        DB::transaction(function() use ($currency, $data) {
//            if (parent::update($currency, $data)) {
//                //For whatever reason this just wont work in the above call, so a second is needed for now
//
//                parent::save($currency);
//
//
//
//                //event(new UserUpdated($currency));
//                return true;
//            }
//
//            throw new GeneralException(trans('exceptions.backend.takeaway.currency.update_error'));
//        });
//    }

    public function update(Model $currency, array $input)
    {
        $data = $input['data']->all();

        DB::transaction(function() use ($currency, $data) {
            if ($currency->update($data)) {
                //For whatever reason this just wont work in the above call, so a second is needed for now

                // $cuisine->save($cuisine);



                //event(new UserUpdated($cuisine));
                return true;
            }

            throw new GeneralException(trans('exceptions.backend.takeaway.cuisine.update_error'));
        });
    }
    /**
     * @param Model $user
     * @return bool
     * @throws GeneralException
     */
    public function delete(Model $currency)
    {
        if (parent::delete($currency)) {
            ///event(new UserDeleted($currency));
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.takeaway.currency.delete_error'));
    }

    /**
     * @param Model $user
     * @throws GeneralException
     */
    public function forceDelete(Model $currency)
    {
        if (is_null($currency->deleted_at)) {
            throw new GeneralException(trans('exceptions.backend.takeaway.currency.delete_first'));
        }

        DB::transaction(function() use ($currency) {
            if (parent::forceDelete($currency)) {
                //event(new UserPermanentlyDeleted($currency));
                return true;
            }

            throw new GeneralException(trans('exceptions.backend.takeaway.currency.delete_error'));
        });
    }

    /**
     * @param Model $user
     * @return bool
     * @throws GeneralException
     */
    public function restore(Model $currency)
    {
        if (is_null($currency->deleted_at)) {
            throw new GeneralException(trans('exceptions.backend.takeaway.currency.cant_restore'));
        }

        if (parent::restore(($currency))) {
            //event(new UserRestored($currency));
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.takeaway.currency.restore_error'));
    }




    /**
     * @param  $input
     * @return mixed
     */
    protected function createUserStub($input)
    {
        $currencies					 = self::MODEL;
        $currencies                    = new $currencies;
        $currencies->currency_code              = $input['currency_code'];
        $currencies->amount              = $input['amount'];
        $currencies->agency_id              = $input['agency_id'];
//        $currencies->status              = $input['status'];


        return $currencies;
    }
}
