<?php
/**
 * Created by PhpStorm.
 * User: Sohaib
 * Date: 1/28/2019
 * Time: 4:55 PM
 */
namespace App\Repositories\Backend\Superadmin;

use App\Models\Superadmin\Agents\Agents;
use App\Repositories\BaseRepository;
use Illuminate\Support\Facades\DB;
use App\Exceptions\GeneralException;
use Illuminate\Database\Eloquent\Model;



class AgentsRepository extends BaseRepository
{
    const MODEL = Agents::class;

    public function model()
    {

    }
    public function __construct(){

    }


    public function getForDataTable($status = 1, $trashed = false)
    {
        $dataTableQuery = $this->query()
            ->select([
                config('tables.agent_table') . '.id',
                config('tables.agent_table') . '.first_name',
                config('tables.agent_table') . '.last_name',
                config('tables.agent_table') . '.phone',
                config('tables.agent_table') . '.mobile',
                config('tables.agent_table') . '.email',
                config('tables.agent_table') . '.agency_id',
                config('tables.agent_table') . '.country',
                config('tables.agent_table') . '.website',
                config('tables.agent_table') . '.status',
                config('tables.agent_table') . '.created_at',
                config('tables.agent_table') . '.updated_at',

            ]);

        if ($trashed == "true") {
            return $dataTableQuery->onlyTrashed();
        }
        // active() is a scope on the UserScope trait
        return $dataTableQuery;
    }

    public function update(Model $agent, array $input)
    {
        $data = $input['data']->all();
        DB::transaction(function() use ($agent, $data) {

            if ($agent->update($data))
            {


                return true;
            }

            throw new GeneralException(trans('exceptions.backend.update_error'));
        });
    }

    public function getModel()
    {
        return $this->agent;
    }

    public function setModel($agent)
    {
        $this->agent = $agent;
        return $this;
    }

}
