<?php
/**
 * Created by PhpStorm.
 * User: Sohaib
 * Date: 3/21/2019
 * Time: 4:54 PM
 */

namespace App\Repositories\Backend\Customers;
use Illuminate\Support\Facades\Auth;
use App\Models\Customers\Leads\Validleads;
use App\Repositories\BaseRepository;
use DB;
use App\Exceptions\GeneralException;
use Illuminate\Database\Eloquent\Model;
use Jcf\Geocode\Geocode;


class ValidleadsRepository extends BaseRepository
{
    const MODEL = Validleads::class;


    public function __construct()
    {

    }
    public function getForDataTable($status = 1, $trashed = false)
    {
        if (access()->hasRole('Administrator')){
            $dataTableQuery = $this->query()

                ->where('isverfied',1)
                ->where('isvalidated',1)
                ->select([
                    config('tables.leads_table') . '.id',
                    config('tables.leads_table') . '.fname',
                    config('tables.leads_table') . '.lname',
                    config('tables.leads_table') . '.email',
                    config('tables.leads_table') . '.pphone',
                    config('tables.leads_table') . '.created_at',
                    config('tables.leads_table') . '.updated_at',

                ]);
        }
        if (!access()->hasRole('Administrator')) {
            $dataTableQuery = $this->query()
                ->where('isverfied', 1)
                ->where('isvalidated', 0)
                ->where('transferto', 0)
                ->select([
                    config('tables.leads_table') . '.id',
                    config('tables.leads_table') . '.fname',
                    config('tables.leads_table') . '.lname',
                    config('tables.leads_table') . '.email',
                    config('tables.leads_table') . '.pphone',
                    config('tables.leads_table') . '.created_at',
                    config('tables.leads_table') . '.updated_at',

                ]);
        }
        if ($trashed == "true") {
            return $dataTableQuery->onlyTrashed();
        }
        // active() is a scope on the UserScope trait
        return $dataTableQuery;
    }

    public function create($input)
    {
        $data = $input['data'];
        $contacts = $this->createUserStub($data);
        DB::transaction(function() use ($contacts, $data) {
            if ($contacts->save())
            {
                return true;
            }

            throw new GeneralException(trans('exceptions.backend.create_error'));
        });
    }


    public function update(Model $leads, array $input)
    {
        $data = $input['data']->all();
        DB::transaction(function() use ($leads, $data) {

            if ($leads->update($data))
            {
//                $response = Geocode::make()->address($data['address']);
//                DB::table('dx_contacts')
//                    ->where('id', $contacts->id)
//                    ->update([
//                        'fullname' => $data['fullname'],
//                        'lat' => $response->latitude(),
//                        'lng' => $response->longitude(),
//                        ]);

                return true;
            }

            throw new GeneralException(trans('exceptions.backend.update_error'));
        });
    }
    public function delete(Model $contacts)
    {
        if (parent::delete($contacts))
        {
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.delete_error'));
    }


    public function forceDelete(Model $contacts)
    {
        if (is_null($contacts->deleted_at))
        {
            throw new GeneralException(trans('exceptions.backend.delete_first'));
        }

        DB::transaction(function() use ($contacts) {
            if (parent::forceDelete($contacts))
            {
                return true;
            }

            throw new GeneralException(trans('exceptions.backend.delete_error'));
        });
    }

    public function restore(Model $contacts)
    {
        if (is_null($contacts->deleted_at))
        {
            throw new GeneralException(trans('exceptions.backend.cant_restore'));
        }

        if (parent::restore(($contacts)))
        {
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.restore_error'));
    }




    protected function createUserStub($input)
    {
        $response = Geocode::make()->address($input->address);

        $user_id = Auth::id();
        $contacts					 = self::MODEL;
        $contacts                    = new $contacts;
        $contacts->fullname          = $input['fullname'];
        $contacts->email             = $input['email'];
        $contacts->phone             = $input['phone'];
        $contacts->address           = $input['address'];
        $contacts->status            = $input['status'];
        $contacts->user_id           = $user_id;
        $contacts->lat               = $response->latitude();
        $contacts->lng               = $response->longitude();

        return $contacts;
    }
}
