<?php

namespace App\Repositories\Backend\Customers;
use Illuminate\Support\Facades\Auth;
//use App\Models\Customers\Contacts\Contacts;
use App\Models\Customers\Agents\Agents;
use App\Models\Customers\Agents\Agents2;
use App\Repositories\BaseRepository;
use DB;
use App\Exceptions\GeneralException;
use Illuminate\Database\Eloquent\Model;
use Jcf\Geocode\Geocode;


class AgentsRepository extends BaseRepository
{
    const MODEL = Agents::class;

    public function __construct()
    {

    }

    public function getForDataTable($status = 1, $trashed = false)
    {
        $dataTableQuery = $this->query()

            ->select([
                config('tables.agent_table') . '.id',
                config('tables.agent_table') . '.first_name',
                config('tables.agent_table') . '.last_name',
                config('tables.agent_table') . '.phone',
                config('tables.agent_table') . '.mobile',
                config('tables.agent_table') . '.email',
                config('tables.agent_table') . '.agency_id',
                config('tables.agent_table') . '.status',
                config('tables.agent_table') . '.created_at',
                config('tables.agent_table') . '.updated_at',
            ]);

        if ($trashed == "true") {
            return $dataTableQuery->onlyTrashed();
        }
        return $dataTableQuery;
    }

    public function create($input)
    {
        $data = $input['data'];
        $agents = $this->createUserStub($data);
        DB::transaction(function() use ($agents, $data) {
            if ($agents->save()) {
                return true;
            }

            throw new GeneralException(trans('exceptions.backend.create_error'));
        });
    }



    protected function createUserStub($input)
    {
        $agents					    = self::MODEL;
        $agents                        = new $agents;
        $agents->email                 = $input['email'];
        $agents->password           =bcrypt($input['password']);
        $agents->first_name         =$input['first_name'];
        $agents->last_name         =$input['last_name'];


        $agents->save();
        return $agents;
    }
}
