<?php

namespace App\Repositories\Backend\Agents;
use Illuminate\Support\Facades\Auth;
use App\Models\Agents\Leads\Leads;
use App\Repositories\BaseRepository;
use DB;
use App\Exceptions\GeneralException;
use Illuminate\Database\Eloquent\Model;
use Jcf\Geocode\Geocode;


class LeadsRepository extends BaseRepository
{
    const MODEL = Leads::class;


    public function __construct()
    {

    }
    public function getForDataTable($status = 1, $trashed = false)
    {
        $user_id = Auth::user();

        $dataTableQuery = $this->query()
            ->where('transferto',$user_id->agent_id)
            ->select([
                config('tables.leads_table') . '.id',
                config('tables.leads_table') . '.fname',
                config('tables.leads_table') . '.lname',
                config('tables.leads_table') . '.email',
                config('tables.leads_table') . '.pphone',
                config('tables.leads_table') . '.created_at',
                config('tables.leads_table') . '.updated_at',

            ]);

        if ($trashed == "true") {
            return $dataTableQuery->onlyTrashed();
        }
        // active() is a scope on the UserScope trait
        return $dataTableQuery;
    }

    public function getForCustomeDataTable($status = 1, $trashed = false)
    {
//        dd('oye');
        $dataTableQuery = $this->query()
            ->select([
                config('tables.leads_table') . '.id',
                config('tables.leads_table') . '.fname',
                config('tables.leads_table') . '.lname',
                config('tables.leads_table') . '.pphone',
                config('tables.leads_table') . '.sphone',
                config('tables.leads_table') . '.email',
                config('tables.leads_table') . '.address',
                config('tables.leads_table') . '.city',
                config('tables.leads_table') . '.state',
                config('tables.leads_table') . '.zip',
                config('tables.leads_table') . '.gender',
                config('tables.leads_table') . '.gender',
                config('tables.leads_table') . '.age',
                config('tables.leads_table') . '.self_assessed_credit',
                config('tables.leads_table') . '.home_type',
                config('tables.leads_table') . '.year_built',
                config('tables.leads_table') . '.square_feet',
                config('tables.leads_table') . '.bedrooms',
                config('tables.leads_table') . '.bathrooms',
                config('tables.leads_table') . '.construction_type',
                config('tables.leads_table') . '.roof_surface',
                config('tables.leads_table') . '.foundation_type',
                config('tables.leads_table') . '.exterior_walls',
                config('tables.leads_table') . '.garage_type',
                config('tables.leads_table') . '.total_stories',
                config('tables.leads_table') . '.electrical_system',
                config('tables.leads_table') . '.fireplaces',
                config('tables.leads_table') . '.pool',
                config('tables.leads_table') . '.patio_deck',
                config('tables.leads_table') . '.alarm',
                config('tables.leads_table') . '.central_ac',
                config('tables.leads_table') . '.dead_bolt',
                config('tables.leads_table') . '.smoke_detector',
                config('tables.leads_table') . '.fire_extinguisher',
                config('tables.leads_table') . '.smoker_in_home',
                config('tables.leads_table') . '.dog_in_home',
                config('tables.leads_table') . '.near_fire_station',
                config('tables.leads_table') . '.near_fire_hydrant',
                config('tables.leads_table') . '.currently_insured',
                config('tables.leads_table') . '.current_carrier',
                config('tables.leads_table') . '.residence_coverage_amount',
                config('tables.leads_table') . '.personal_property_amount',
                config('tables.leads_table') . '.personal_liability_amount',
                config('tables.leads_table') . '.deductible_amount',
                config('tables.leads_table') . '.years_continuously_covered',
                config('tables.leads_table') . '.policy_expiration',
                config('tables.leads_table') . '.property_address',
                config('tables.leads_table') . '.property_city',
                config('tables.leads_table') . '.property_state',
                config('tables.leads_table') . '.property_zip',
                config('tables.leads_table') . '.property_use',
                config('tables.leads_table') . '.home_value',
                config('tables.leads_table') . '.isverfied',
                config('tables.leads_table') . '.isvalidated',
                config('tables.leads_table') . '.status',

            ]);

        if ($trashed == "true") {
            return $dataTableQuery->onlyTrashed();
        }
        // active() is a scope on the UserScope trait
        return $dataTableQuery;
    }

    public function create($input)
    {
        $data = $input['data'];
        $contacts = $this->createUserStub($data);
        DB::transaction(function() use ($contacts, $data) {
            if ($contacts->save())
            {
                return true;
            }

            throw new GeneralException(trans('exceptions.backend.create_error'));
        });
    }


    public function update(Model $leads, array $input)
    {
        $data = $input['data']->all();
        DB::transaction(function() use ($leads, $data) {

            if ($leads->update($data))
            {
//                $response = Geocode::make()->address($data['address']);
//                DB::table('dx_contacts')
//                    ->where('id', $contacts->id)
//                    ->update([
//                        'fullname' => $data['fullname'],
//                        'lat' => $response->latitude(),
//                        'lng' => $response->longitude(),
//                        ]);

                return true;
            }

            throw new GeneralException(trans('exceptions.backend.update_error'));
        });
    }
    public function delete(Model $contacts)
    {
        if (parent::delete($contacts))
        {
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.delete_error'));
    }


    public function forceDelete(Model $contacts)
    {
        if (is_null($contacts->deleted_at))
        {
            throw new GeneralException(trans('exceptions.backend.delete_first'));
        }

        DB::transaction(function() use ($contacts) {
            if (parent::forceDelete($contacts))
            {
                return true;
            }

            throw new GeneralException(trans('exceptions.backend.delete_error'));
        });
    }

    public function restore(Model $contacts)
    {
        if (is_null($contacts->deleted_at))
        {
            throw new GeneralException(trans('exceptions.backend.cant_restore'));
        }

        if (parent::restore(($contacts)))
        {
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.restore_error'));
    }




    protected function createUserStub($input)
    {
        $response = Geocode::make()->address($input->address);

        $user_id = Auth::id();
        $contacts					 = self::MODEL;
        $contacts                    = new $contacts;
        $contacts->fullname          = $input['fullname'];
        $contacts->email             = $input['email'];
        $contacts->phone             = $input['phone'];
        $contacts->address           = $input['address'];
        $contacts->status            = $input['status'];
        $contacts->user_id           = $user_id;
        $contacts->lat               = $response->latitude();
        $contacts->lng               = $response->longitude();

        return $contacts;
    }
}
