<?php

namespace App\Providers;

use Form;
use Illuminate\Support\ServiceProvider;

class FormServiceProvider extends ServiceProvider
{
    /**
     * Register bindings in the container.
     *
     * @return void
     */
    public function boot()
    {
        // Form components
        Form::component('textGroup', 'backend.includes.partials.form.text_group', [
            'name', 'text', 'icon', 'attributes' => ['required' => 'required'], 'value' => null, 'col' => 'col-md-6',
        ]);

        Form::component('textGroupFullWidth', 'backend.includes.partials.form.text_group', [
            'name', 'text', 'icon', 'attributes' => ['required' => 'required'], 'value' => null, 'col' => 'col-md-12',
        ]);

        Form::component('emailGroup', 'backend.includes.partials.form.email_group', [
            'name', 'text', 'icon', 'attributes' => ['required' => 'required'], 'value' => null, 'col' => 'col-md-6',
        ]);

        Form::component('passwordGroup', 'backend.includes.partials.form.password_group', [
            'name', 'text', 'icon', 'attributes' => ['required' => 'required'], 'value' => null, 'col' => 'col-md-6',
        ]);

        Form::component('selectGroup', 'backend.includes.partials.form.select_group', [
            'name', 'text', 'icon', 'values', 'selected' => null, 'attributes' => ['required' => 'required'], 'col' => 'col-md-6',
        ]);

        Form::component('selectGroupFullWidth', 'backend.includes.partials.form.select_group', [
            'name', 'text', 'icon', 'values', 'selected' => null, 'attributes' => ['required' => 'required'], 'col' => 'col-md-12',
        ]);

        Form::component('textareaGroup', 'backend.includes.partials.form.textarea_group', [
            'name', 'text', 'value' => null, 'attributes' => ['rows' => '3'], 'col' => 'col-md-12',
        ]);

        Form::component('radioGroup', 'backend.includes.partials.form.radio_group', [
            'name', 'text', 'enable' => trans('general.yes'), 'disable' => trans('general.no'), 'attributes' => [], 'col' => 'col-md-6',
        ]);

        Form::component('checkboxGroup', 'backend.includes.partials.form.checkbox_group', [
            'name', 'text', 'items' => [], 'value' => 'name', 'id' => 'id', 'attributes' => ['required' => 'required'], 'col' => 'col-md-12',
        ]);

        Form::component('fileGroup', 'backend.includes.partials.form.file_group', [
            'name', 'text', 'attributes' => [], 'col' => 'col-md-6',
        ]);

        Form::component('deleteButton', 'backend.includes.partials.form.delete_button', [
            'item', 'url', 'text' => '', 'value' => 'name', 'id' => 'id',
        ]);

        Form::component('deleteLink', 'backend.includes.partials.form.delete_link', [
            'item', 'url', 'text' => '', 'value' => 'name', 'id' => 'id',
        ]);

        Form::component('saveButtons', 'backend.includes.partials.form.save_buttons', [
            'cancel', 'col' => 'col-md-12',
        ]);
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}