<?php

namespace App\Models\Superadmin\Currency;

use App\Models\Superadmin\Currency\Traits\Attribute\CurrencyAttribute;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;

class Currency extends Model
{
    use CurrencyAttribute,
        Notifiable,
        SoftDeletes;

    protected $table;

    protected $fillable = [
        'currency_code',
        'agency_id',
        'amount',
    ];

    protected $dates = ['deleted_at'];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = config('tables.currencies_table');

    }
}
