<?php

namespace App\Models\Superadmin\Country;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use App\Models\Superadmin\Country\Traits\Attribute\CountryAttribute;
use Illuminate\Database\Eloquent\SoftDeletes;



class Country extends Model
{
    use CountryAttribute,
        Notifiable,
        SoftDeletes;

    protected $table;

    protected $fillable = [
        'name',
        'status'
    ];

    protected $dates = ['deleted_at'];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = config('tables.country_table');
    }
}
