<?php

namespace App\Models\Superadmin\Agents\Traits\Attribute;


trait AgentsAttribute
{

    public function getShowButtonAttribute()
    {
        return '<a href="' . route('admin.superadmin.agents.show', $this) . '" class="btn btn-xs btn-info"><i class="fa fa-search" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.view') . '"></i></a> ';
    }

//    public function getWalletButtonAttribute()
//    {
//        return '<a href="' . route('admin.superadmin.walleturi.get', $this) . '" class="btn btn-xs btn-info"><i class="fa fa-credit-card-alt" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.view') . '"></i></a> ';
//    }

    public function getEditButtonAttribute()
    {
        return '<a href="' . route('admin.superadmin.agents.edit', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-edit" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.edit') . '"></i></a> ';
    }


    public function deletebutton()
    {
        return '<a href="' . route('admin.superadmin.deleteagency', $this) . '" class="btn btn-xs btn-primary">Delete</i></a> ';
    }


    public function getonDeleteButtonAttribute()
    {

        return '<a href="' . route('admin.superadmin.deleteagency', $this) . '"
                 data-method="delete"
                 data-trans-button-cancel="' . trans('buttons.general.cancel') . '"
                 data-trans-button-confirm="' . trans('buttons.general.crud.delete') . '"
                 data-trans-title="' . trans('strings.backend.general.are_you_sure') . '"
                 class="btn btn-xs btn-danger"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.delete') . '"></i></a> ';

    }


    public function getRestoreButtonAttribute()
    {
        return '<a href="' . route('admin.superadmin.agents.restore', $this) . '" name="restore_user" class="btn btn-xs btn-info"><i class="fa fa-refresh" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.backend.access.users.restore_user') . '"></i></a> ';
    }


    public function getDeletePermanentlyButtonAttribute()
    {
        return '<a href="' . route('admin.superadmin.agents.delete-permanently', $this) . '" name="delete_user_perm" class="btn btn-xs btn-danger"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.backend.access.users.delete_permanently') . '"></i></a> ';
    }

    public function getActionButtonsAttribute()
    {
        if ($this->trashed()) {
            return $this->getRestoreButtonAttribute() .
                $this->getDeletePermanentlyButtonAttribute();
        }

        return
            $this->getShowButtonAttribute() .
            $this->getEditButtonAttribute() ;
//            $this->getWalletButtonAttribute() .
//            $this->getonDeleteButtonAttribute();
    }
}
