<?php

namespace App\Models\Customers\Setting;

use App\Scopes\User;
use Illuminate\Database\Eloquent\Model;
use App\Models\Superadmin\Country\Traits\Attribute\CountryAttribute;

class Setting extends Model
{

    protected $table = "dx_settings";

    protected $fillable = ['user_id', 'key', 'value'];

    protected static function boot()
    {
        parent::boot();

        static::addGlobalScope(new User);
    }

    public static function all($code = 'general')
    {
        return static::where('key', 'like', $code . '.%')->get();
    }

    public function user()
    {
        return $this->belongsTo('App\Models\Access\User\User');
    }

    public function scopeCompanyId($query, $company_id)
    {
        return $query->where($this->table . '.user_id', '=', $company_id);
    }
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = config('tables.country_table');
    }
}
