<?php

namespace App\Models\Customers\Agents;


use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;
use App\Models\Customers\Agents\Traits\Attributes\Agents2Attribute;
use DB;
use Jackpopp\GeoDistance\GeoDistanceTrait;
class Agents2 extends Model
{
    use GeoDistanceTrait;

    use Agents2Attribute,
        Notifiable,
        SoftDeletes;

    protected $table;

    protected $fillable = [

        'on_duty',
        'first_name',
        'last_name',
        'phone',
        'transport_type_id',
        'transport_description',
        'licence_plate',
        'color',
        'status',
        'location_address',
        'lat',
        'lng',
        'device_id',
        'device_platform',
        'enabled_push',
        'profile_photo',
        'app_version',

    ];





    protected $dates = ['deleted_at'];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = config('tables.user_driver_detail');
    }
}
