<?php

namespace App\Models\Customers\Agents;


use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;
use App\Models\Customers\Agents\Traits\Attributes\AgentsAttribute;

class Agents extends Model
{
    use
//        AgentsAttribute,
        Notifiable,
        SoftDeletes;

    protected $table;

    protected $fillable = [
        'first_name',
        'last_name',
        'phone',
        'mobile',
        'email',
        'agency_id',
        'status',
    ];

    protected $dates = ['deleted_at'];
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = config('tables.agent_table');
    }
}
