<?php
/**
 * Created by PhpStorm.
 * User: Sohaib
 * Date: 3/21/2019
 * Time: 4:52 PM
 */

namespace App\Models\Customers\Leads;


use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;
use App\Models\Customers\Leads\Traits\Attribute\ValidleadsAttribute;

class Validleads extends Model
{
    use
        ValidleadsAttribute,
        Notifiable,
        SoftDeletes;

    protected $table;


    protected $fillable = [
        'id',
        'fname',
        'lname',
        'pphone',
        'sphone',
        'email',
        'address',
        'city',
        'state',
        'zip',
        'gender',
        'gender',
        'age',
        'self_assessed_credit',
        'home_type',
        'year_built',
        'square_feet',
        'bedrooms',
        'bathrooms',
        ',construction_type',
        'roof_surface',
        'foundation_type',
        'exterior_walls',
        'garage_type',
        'total_stories',
        'electrical_system',
        'fireplaces',
        'pool',
        'patio_deck',
        'alarm',
        'central_ac',
        'dead_bolt',
        'smoke_detector',
        'fire_extinguisher',
        'smoker_in_home',
        'dog_in_home',
        'near_fire_station',
        'near_fire_hydrant',
        'currently_insured',
        'current_carrier',
        'residence_coverage_amount',
        'personal_property_amount',
        'personal_liability_amount',
        'deductible_amount',
        'years_continuously_covered',
        'policy_expiration',
        'property_address',
        'property_city',
        'property_state',
        'property_zip',
        'property_use',
        'home_value',
        'isverfied',
        'isvalidated',
        'status',

    ];

    protected $dates = ['deleted_at'];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = config('tables.leads_table');
    }
    public function getTableColumns() {
        return $this->getConnection()->getSchemaBuilder()->getColumnListing($this->getTable());
    }
}
