<?php

namespace App\Models\Agency\Agents\Traits\Attribute;


trait AgentsAttribute
{

    public function getShowButtonAttribute()
    {
        return '<a href="' . route('admin.agency.agents.show', $this) . '" class="btn btn-xs btn-info"><i class="fa fa-search" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.view') . '"></i></a> ';
    }

    public function getEditButtonAttribute()
    {
        return '<a href="' . route('admin.agency.agents.edit', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-edit" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.edit') . '"></i></a> ';
    }

    public function deletebutton()
    {
        return '<a href="' . route('admin.agency.deleteagency', $this) . '" class="btn btn-xs btn-primary">Delete</i></a> ';
    }

    public function getDeleteButtonAttribute()
    {

        return '<a href="' . route('admin.agency.agents.destroy', $this) . '"
                 data-method="delete"
                 data-trans-button-cancel="' . trans('buttons.general.cancel') . '"
                 data-trans-button-confirm="' . trans('buttons.general.crud.delete') . '"
                 data-trans-title="' . trans('strings.backend.general.are_you_sure') . '"
                 class="btn btn-xs btn-danger"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.delete') . '"></i></a> ';

    }

    public function getRestoreButtonAttribute()
    {
        return '<a href="' . route('admin.agency.agents.restore', $this) . '" name="restore_user" class="btn btn-xs btn-info"><i class="fa fa-refresh" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.backend.access.users.restore_user') . '"></i></a> ';
    }

public function togal(){
    return '';

}

    public function getDeletePermanentlyButtonAttribute()
    {
        return '<a href="' . route('admin.agency.agents.delete-permanently', $this) . '" name="delete_user_perm" class="btn btn-xs btn-danger"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.backend.access.users.delete_permanently') . '"></i></a> ';
    }

    public function getActionButtonsAttribute()
    {
        if ($this->trashed()) {
            return $this->getRestoreButtonAttribute() .
                $this->getDeletePermanentlyButtonAttribute();
        }

        return
//        $this->togal() .
            $this->getShowButtonAttribute() .
            $this->getEditButtonAttribute() .
            $this->getDeleteButtonAttribute();
    }
}
