<?php
/**
 * Created by PhpStorm.
 * User: Sohaib
 * Date: 6/30/2019
 * Time: 11:57 AM
 */
namespace App\Http\Requests\Backend\Superadmin;

use App\Http\Requests\Request;

/**
 * Class CreateAgencyRequest.
 */
class AgencyeditRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return access()->hasRole(1);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'agency_name'=>['required', 'regex:/^[\pL\s\-]+$/u' ,'unique:dx_agencies,agency_name,'. $this->route('plan')->id .',id,address,'.$this->input("address")],
            'phone'=> 'required|numeric|digits_between:9,10',
            'email'=> 'email | required',
            'website'=> 'required',
            'transection_price'=>'required|numeric',
            'country'=> 'required',
            'city'=> 'required',
            'address'=> 'required',
            'state'=> 'required',
            'zip_code' => 'required',
        ];
    }
}
