<?php
/**
 * Created by PhpStorm.
 * User: Sohaib
 * Date: 3/24/2019
 * Time: 12:02 PM
 */

namespace App\Http\Requests\Backend\Superadmin;

use App\Http\Requests\Request;

/**
 * Class CreateAgencyRequest.
 */
class AgencycreateRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return access()->hasRole(1);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'first_name'=>'required|regex:/^[\pL\s\-]+$/u',
            'last_name'=>'required|regex:/^[\pL\s\-]+$/u',
            'agency_name' => ['required', 'regex:/^[\pL\s\-]+$/u' ,'unique:dx_agencies,agency_name,NULL,id,address,'.$this->input("address")],
            'phone'=> 'required|numeric|digits_between:9,10',
            'email'=> 'email | required',
            'website'=> 'required',
            'transection_price'=>'required|numeric',
            'country'=> 'required',
            'city'=> 'required',
            'address'=> 'required',
            'state'=> 'required',
            'zip_code' => 'required',
            'stripeToken' => 'required'
        ];
    }
}
