<?php

namespace App\Http\Requests\Backend\Customers;

use App\Http\Requests\Request;


class TasksRequest extends Request
{


    public function authorize()
    {
        return true;
    }



    public function rules()
    {
        return [
            'phone' => 'required|numeric|digits_between:12,12',
            'restaurant_name' => 'required|regex:/^[\pL\s\-]+$/u',
            'datepicker' => 'required',
            'delivery_address' => 'required',
            'team' => 'required',


        ];
    }
}
