<?php

namespace App\Http\Requests\Backend\Customers;

use App\Http\Requests\Request;


class ContactsRequest extends Request
{


    public function authorize()
    {
        return true;
    }



    public function rules()
    {
        return [
            'fullname' => 'required|regex:/^[\pL\s\-]+$/u',
            'email' => 'email | required',
            'phone' => 'required|numeric|digits_between:12,12',
            'address' => 'required',
            'status' => 'required',


        ];
    }
}
