<?php

namespace App\Http\Requests\Backend\Customers;

use App\Http\Requests\Request;


class AgentsRequest extends Request
{


    public function authorize()
    {
        return true;
    }



    public function rules()
    {
        return [
            'first_name' => 'alpha | required',
            'last_name' => 'alpha | required',
            'phone' => 'required|numeric|digits_between:12,12',
            'transport_type_id' => 'required',
            'transport_description' => 'required',
            'licence_plate' => 'required',
            'color' => 'alpha | required',
            'status' => 'required',
            'email' => 'email | required',
            'password' => 'required',
            'team_id' => 'required',
            'address' => 'required',
        ];
    }
}
