<?php



namespace App\Http\Requests\Backend\Superadmin;



use App\Http\Requests\Request;



/**

 * Class UpdateUserRequest.

 */

class CreateagentRequest extends Request

{

    /**

     * Determine if the user is authorized to make this request.

     *

     * @return bool

     */

    public function authorize()

    {

        return access()->hasRole(1);

    }



    /**

     * Get the validation rules that apply to the request.

     *

     * @return array

     */

    public function rules()

    {

        return [

            'first_name'=>'required|regex:/^[\pL\s\-]+$/u',

            'last_name'=>'required|regex:/^[\pL\s\-]+$/u',

            'phone'=> 'required|numeric|digits_between:9,10',

            'mobile'=>'required|numeric|digits_between:9,10',

            'email'=> 'email | required',
            
            'password'=> 'required|min:6|max:6',

            'agency_id'=> 'required'



        ];

    }

}

