<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Superadmin\Plans\Plans;
use App\Models\Superadmin\Settings\Settings;
use DB;
use App\Helpers\Frontend\Auth\Socialite;
use Illuminate\Http\Request;
use Auth;
use Jcf\Geocode\Geocode;
use Twilio\Rest\Client;
use Carbon\Carbon;

/**
 * Class FrontendController.
 */
class FrontendController extends Controller
{

    public function index()
    {
        $plans = DB::table('dx_plans')->get();
        return view('frontend.index', ['plans' => $plans]);
    }

    public function macros()
    {
        return view('frontend.macros');
    }

    public function payment_method()
    {

        return view('frontend.payments.payment_selection');
    }

    public function payments()
    {
        $last = DB::table('users')->latest()->first();
        $plan = Plans::where('id', $last->plan_id)->first();
//        dd($plan);
        return view('frontend.payments.payments',['plan'=>$plan]);
    }

    public function about()
    {
        $ad = DB::table('dx_cmspages')->where('page_title', 'about us')->first();
        $adout_we_do = DB::table('dx_cmspages')->where('page_title', 'about us what we do')->first();
        $adout_our_history = DB::table('dx_cmspages')->where('page_title', 'about us our history')->first();
        $adout_our_mission = DB::table('dx_cmspages')->where('page_title', 'about us our mission')->first();
        return view('frontend.about_us',['ad'=>$ad,'adout_we_do'=>$adout_we_do,
            'adout_our_history'=>$adout_our_history,'adout_our_mission'=>$adout_our_mission]);
    }

    public function tracking()
    {
        return view('frontend.tracking');
    }

    public function pricing()
    {
        $plans = DB::table('dx_plans')->get();
       // dd($plans);
        return view('frontend.pricing_plans', ['plans' => $plans]);
    }

    public function contact()
    {
        $address = DB::table('dx_settings')->where('key', 'general.company_address')->first();
        $response = Geocode::make()->address($address->value);
        $lat = $response->latitude();
        $lng = $response->longitude();

        return view('frontend.contact_us', ['lat' => $lat, 'lng' => $lng]);
    }

    public function blog()
    {
        return view('frontend.blog');
    }

    public function pages()
    {
        return view('frontend.pages');
    }

    public function thankyou()
    {
        return view('frontend.payments.thankyou');
    }

    public function signup()
    {
        $plans = DB::table('dx_plans')->get();
        return view('frontend.signup_plans', ['plans' => $plans]);
    }

    public function showRegistrationForm($id)
    {

        $plan = Plans::where('id', $id)->first();
//        dd($plan);
        $user = Auth::user();
        if ($user)
        {
            return view('frontend.payments.payment_selection',['id' => $id,'user'=>$user,'plan'=>$plan]);
        }
        else {
            return view('frontend.auth.register', ['id' => $id]);
        }
    }

    public function showLoginForm()
    {
        return view('frontend.auth.login')->withSocialiteLinks((new Socialite())->getSocialLinks());
    }

    public function sms()
    {
        $user = Auth::user();
        if ($user)
        {
            $check = DB::table('user_customer_details')->where('user_id', $user->id)->first();
            if ($check == NULL)
            {
                return back()->withFlashSuccess(trans('Sorry! You do not have any Plan, First of all Please choose a Plan'));
            }
            else
            {
                $user = Auth::user();
                $Sid = DB::table('user_customer_details')->where('user_id', '=', $user->id)->first();
                return view('frontend.sms_form', ['Sid' => $Sid]);
            }
        }
    }

    public function sms_post(Request $request)
    {
//        dd($request);
        $to = $request->to;
//        $to = '+'.$too;
//dd($to);
        $message = $request->message;
        $user = Auth::user();
        $Sid = DB::table('user_customer_details')->where('user_id', '=', $user->id)->first();
        $nexmo_or_twilio = DB::table('dx_settings')->where('key', 'general.twilio')->first();
        if ($Sid->verification_code !== '0')
        {
            if ($nexmo_or_twilio->value == "Twilio")
            {
                if ($Sid->sms_limit > 0)
                {
                    $AccountSid = DB::table('dx_settings')->where('key', 'general.sms_gateway_account_sid')->first();
                    $AuthToken = DB::table('dx_settings')->where('key', 'general.sms_gateway_auth_token')->first();
                    $twilio_senderid = DB::table('dx_settings')->where('key', 'general.sms_gateway_sender_id')->first();
//                    dd($twilio_senderid);
                    $client = new Client($AccountSid->value, $AuthToken->value);
                    $sms = $client->account->messages->create(
                        '+'.$to,
                        array(
                            'from' => $twilio_senderid->value,
                            'body' => "$message"
                        )
                    );
                    $smslimit = $Sid->sms_limit - 1;
                    DB::table('user_customer_details')->where('user_id', $user->id)->update(['sms_limit' => $smslimit]);
                    return redirect()->route('frontend.sms')->withFlashSuccess(trans('Message has been sent.'));

                }
                else
                {
                    return redirect()->route('frontend.sms')->withFlashSuccess(trans('Your SMS limit is end'));
                }
            }
            else
            {
                if ($Sid->sms_limit > 0)
                {
                    $nexmo_senderid = DB::table('dx_settings')->where('key', 'general.sms_gateway_sender')->first();
                    $nexmo = app('Nexmo\Client');
                    $nexmo->message()->send([
                        'to' => $to,
                        'from' => $nexmo_senderid->value,
                        'text' => $message,
                    ]);
                    $smslimit = $Sid->sms_limit - 1;
                    DB::table('user_customer_details')->where('user_id', $user->id)->update(['sms_limit' => $smslimit]);
                    return redirect()->route('frontend.sms')->withFlashSuccess(trans('Message has been sent.'));
                }
                else
                {
                    return redirect()->route('frontend.sms')->withFlashSuccess(trans('Your SMS limit is end'));
                }

            }
        }
        else
        {
            return redirect()->route('frontend.sms')->withFlashSuccess(trans('Please pay your payment'));
        }
    }

    public function check(Request $request)
    {
//        dd($request);
        $mehtod = $request->payment_method;
        $plan_id= $request->plan_id;
        $promocode= $request->promocode;
//dd($plan_id);
        if ($mehtod=='paypal')
        {
            return view('frontend.pages');
            $user = Auth::user();
            if ($user)
            {
                $plan = Plans::where('id', $plan_id)->first();
                return view('frontend.payments.paywithpaypal',['plan'=>$plan]);
            }
            else
            {
                $last = DB::table('users')->latest()->first();
                $plan = Plans::where('id', $last->plan_id)->first();
                return view('frontend.payments.paywithpaypal',['plan'=>$plan]);
            }
        }
        elseif ($mehtod=='stripe')
        {
//            dd('in');
            $user = Auth::user();
            if ($user)
            {
                $plan = Plans::where('id', $plan_id)->first();

                $enable_promocode= DB::table('dx_settings')->where('key','general.enable_promo_code')->first();
//                dd($enable_promocode);
                if ($enable_promocode->value == 1)
                {
                    $promo=DB::table('dx_promocodes')->where('promo_code', $promocode)->first();

                    if ($promo == NULL)
                    {
                        return back()->withFlashDanger(trans('Sorry! Your Promo Code is Invalid Please Try Again'));
                    }
                    $date = new Carbon;
                    $newDate=Carbon::parse($date)->format('m/d/Y');
                    if($newDate > $promo->expiry_date)
                    {
                        $dis_price =0;
                        return view('frontend.payments.paywithstripe',['dis_price'=>$dis_price,'plan'=>$plan,'promocode'=>$promocode]);
                    }
                    else
                    {
//                        dd($plan);
                        $dis_price = $plan->price - $promo->discount_price;
                        return view('frontend.payments.paywithstripe',['dis_price'=>$dis_price,'plan'=>$plan,'promocode'=>$promocode])->withFlashSuccess(trans('Your Promo Code is Expired'));
                    }
                }
                $dis_price =0;
                return view('frontend.payments.paywithstripe',['dis_price'=>$dis_price,'plan'=>$plan,'promocode'=>$promocode]);
//                return view('frontend.payments.paywithstripe',['plan'=>$plan, 'promocode'=>$promocode]);
            }
            else
            {
                $last = DB::table('users')->latest()->first();
                $plan = Plans::where('id', $last->plan_id)->first();

                $enable_promocode= DB::table('dx_settings')->where('key','general.enable_promo_code')->first();
                if ($enable_promocode->value == 1)
                {
                    $promo=DB::table('dx_promocodes')->where('promo_code', $promocode)->first();

                    if ($promo == NULL)
                    {
                        return back()->withFlashDanger(trans('Sorry! Your Promo Code is Invalid Please Try Again'));
                    }
                        $date = new Carbon;
                        $newDate=Carbon::parse($date)->format('m/d/Y');
                    if($newDate > $promo->expiry_date)
                    {
                        $dis_price =0;
                        return view('frontend.payments.paywithstripe',['dis_price'=>$dis_price,'plan'=>$plan,'promocode'=>$promocode]);
                    }
                    else
                    {
                        $dis_price = $plan->price - $promo->discount_price;
                        return view('frontend.payments.paywithstripe',['dis_price'=>$dis_price,'plan'=>$plan,'promocode'=>$promocode])->withFlashSuccess(trans('Your Promo Code is Expired'));
                    }
                }
                    $dis_price =0;
                    return view('frontend.payments.paywithstripe',['dis_price'=>$dis_price,'plan'=>$plan,'promocode'=>$promocode]);
            }
        }
        elseif ($mehtod=='razorpay')
        {
            return view('frontend.pages');
            $user = Auth::user();
            if ($user)
            {
                $plan = Plans::where('id', $plan_id)->first();
                return view('frontend.payments.paywithrazorpay',['plan'=>$plan,'user'=>$user]);
            }
            else
            {
                $last = DB::table('users')->latest()->first();
                $plan = Plans::where('id', $last->plan_id)->first();
                $user = DB::table('users')->latest()->first();
                return view('frontend.payments.paywithrazorpay',['plan'=>$plan,'user'=>$user]);
            }
        }
        elseif ($mehtod=='authorize')
        {
            return view('frontend.pages');

            $user = Auth::user();
            if ($user)
            {
                $plan = Plans::where('id', $plan_id)->first();
                return view('frontend.payments.autho',['plan'=>$plan,'user'=>$user]);
            }
            else
            {
                $last = DB::table('users')->latest()->first();
                $plan = Plans::where('id', $last->plan_id)->first();
                $user = DB::table('users')->latest()->first();
                return view('frontend.payments.autho',['plan'=>$plan,'user'=>$user]);
            }

        }
        elseif ($mehtod=='mercadopago')
        {
            return view('frontend.pages');
        }
        else{
            return back()->withInput()->withFlashDanger(trans('Please Select Payment Method'));
        }
    }

}