<?php

namespace App\Http\Controllers\Frontend\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\ResetsPasswords;
use App\Repositories\Frontend\Access\User\UserRepository;
use DB;
/**
 * Class ResetPasswordController.
 */
class ResetPasswordController extends Controller
{
    use ResetsPasswords;

    /**
     * @var UserRepository
     */
    protected $user;

    /**
     * ChangePasswordController constructor.
     *
     * @param UserRepository $user
     */
    public function __construct(UserRepository $user)
    {
        $this->user = $user;
    }

    /**
     * Display the password reset view for the given token.
     *
     * If no token is present, display the link request form.
     *
     * @param string|null $token
     *
     * @return \Illuminate\Http\Response
     */
    public function showResetForm($token = null)
    {

        if (! $token) {
            return redirect()->route('frontend.auth.password.email');
        }
        // $email = "nomankhan@gmail.com";
        $header_contact= DB::table('dx_settings')->where('key','general.contact_no')->first();
        $logo= DB::table('dx_settings')->where('key','general.desktop_logo')->first();
        $facebook= DB::table('dx_settings')->where('key','general.facebook')->first();
        $twitter= DB::table('dx_settings')->where('key','general.twitter')->first();
        $google= DB::table('dx_settings')->where('key','general.google')->first();
        // dd($header_contact->value);

        $user = $this->user->findByPasswordResetToken($token);
        if ($user == false) {
            return redirect()->route('frontend.auth.password.email')
            ->withFlashDanger(trans('exceptions.frontend.auth.password.reset_problem'));
        }
        // dd($user);
            // return redirect()->route('frontend.auth.password.email');
        $email = $user->email;
        if ($user && app()->make('auth.password.broker')->tokenExists($user, $token)) {
          // dd('in');
            // dd($email);
            return view('frontend.auth.passwords.reset',['email'=>$email,'header_contact'=>$header_contact,'token'=>$token,'logo'=>$logo,'facebook'=>$facebook,'twitter'=>$twitter,'google'=>$google]);
                // ,['email'=>$email,'token'=>
                // $roken]);
            // ->with($email);
                // ->withToken($token)
                // ->withEmail($user->email);
        }
        else{
                    return redirect()->route('frontend.auth.password.email')
            ->withFlashDanger(trans('exceptions.frontend.auth.password.reset_problem'));
        }

        return redirect()->route('frontend.auth.password.email')
            ->withFlashDanger(trans('exceptions.frontend.auth.password.reset_problem'));
    }

    /**
     * Get the response for a successful password reset.
     *
     * @param  string  $response
     * @return \Illuminate\Http\RedirectResponse
     */
    protected function sendResetResponse($response)
    {
        return redirect()->route(homeRoute())->withFlashSuccess(trans($response));
    }
}
