<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Access\User\User;
use App\Message;
use App\Events\NewMessage;
use DB;
use Auth;
class ContactsController extends Controller
{
    public function get()
    {
        // get all users except the authenticated one
        if (access()->hasRole('Agent')){
            /*$user_id = Auth::user()->agent_id;
            $con = DB::table('transfers')->where('id', '!=', $user_id)->groupBy('caller_id')->get();
            $contacts = [];
            foreach ($con as $co){
                $contacts = User::where('id', '=', $co->caller_id)->get();
            }*/
            $contacts = User::where('id', '!=', auth()->id())->get();
//            echo $contacts;
        }
        if(access()->hasRole('Administrator')){
            $contacts = User::where('id', '!=', auth()->id())->get();
        }
        if(access()->hasRole('Caller')){
            $contacts = User::where('id', '!=', auth()->id())->get();
        }
        // get a collection of items where sender_id is the user who sent us a message
        // and messages_count is the number of unread messages we have from him
        $unreadIds = Message::select(\DB::raw('`from` as sender_id, count(`from`) as messages_count'))
            ->where('to', auth()->id())
            ->where('read', null)
            ->groupBy('from')
            ->get();

        // add an unread key to each contact with the count of unread messages
        $contacts = $contacts->map(function($contact) use ($unreadIds) {
            $contactUnread = $unreadIds->where('sender_id', $contact->id)->first();

            $contact->unread = $contactUnread ? $contactUnread->messages_count : 0;

            return $contact;
        });


        return response()->json($contacts);
    }

    public function getMessagesFor($id)
    {
        // mark all messages with the selected contact as read
        Message::where('from', $id)->where('to', auth()->id())->update(['read' => true]);

        // get all messages between the authenticated user and the selected user
        $messages = Message::where(function($q) use ($id) {
            $q->where('from', auth()->id());
            $q->where('to', $id);
        })->orWhere(function($q) use ($id) {
            $q->where('from', $id);
            $q->where('to', auth()->id());
        })
            ->get();

        return response()->json($messages);
    }

    public function send(Request $request)
    {
        $message = Message::create([
            'from' => auth()->id(),
            'to' => $request->contact_id,
            'text' => $request->text
        ]);

        broadcast(new NewMessage($message));

        return response()->json($message);
    }
}
