<?php

namespace App\Http\Controllers\Backend\Superadmin\Reports;

use App\Http\Controllers\Controller;
use DB;
use App\Models\Superadmin\Plans\Plans;
use Illuminate\Http\Request;
use App\Http\Requests\Backend\Superadmin\ReportRequest;

class ReportsController extends Controller
{
    protected $reports;

    public function index()
    {
        $check = 0;
        $agency = Plans::all()->where('status',1)->pluck('agency_name', 'id');
        return view('backend.superadmin.reports.index',['agency' => $agency,'check'=>$check]);
    }

    public function mydata(ReportRequest $request)
    {
        $startdate =date('Y-m-d', strtotime($request->startdate));
        $enddate =date('Y-m-d', strtotime($request->enddate));

        $agency = Plans::all()->where('status',1)->pluck('agency_name', 'id');

        $agencydetails = DB::table('dx_agencies')->where('id',$request->agency_id)->first();

        $agents = DB::table('dx_agents')->where('agency_id',$agencydetails->id)
            ->whereBetween('created_at', [$request->startdate, $request->enddate])
            ->get();

        $transfers = DB::table('transfers')->where('agency_id',$agencydetails->id)
            ->whereBetween('created_at', [$startdate, $enddate])
                ->get()->count();

        $balance = DB::table('dx_agencies')->where('id',$agencydetails->id)
            ->where('status',1)
                ->first();

        $check = 1;
        return view('backend.superadmin.reports.index',['agency' => $agency,'agencydetails'=>$agencydetails,'agents'=>$agents,'transfers'=>$transfers,'balance'=>$balance,'check'=>$check]);
    }
}
