<?php

namespace App\Http\Controllers\Backend\Superadmin\Plans;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Yajra\Datatables\Facades\Datatables;
use App\Repositories\Backend\Superadmin\PlansRepository;

class PlansTableController extends Controller
{
    protected  $plans;
    public function __construct(PlansRepository $plans)
    {
        $this->plans = $plans;

    }
    public function __invoke(Request $request) {
        return Datatables::of($this->plans->getForDataTable())
            ->addColumn('actions', function($plans) {
                return $plans->action_buttons;
            })->editColumn('created_at', function ($var){
                return $var->created_at ? $var->created_at->toFormattedDateString(): $var->created_at;
            })->rawColumns(['actions'])
            ->editColumn('status', function ($status){
                if($status->status==1){return "Active";}
                else if($status->status==0){return "Deactivate";}
            })
            ->make(true);
    }
}
