<?php

namespace App\Http\Controllers\Backend\Superadmin\Plans;

use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Superadmin\AgencycreateRequest;
use App\Http\Requests\Backend\Superadmin\AgencyeditRequest;
use App\Models\Superadmin\Plans\Plans;
use App\Models\Access\User\User;
use Illuminate\Http\Request;
use App\Repositories\Backend\Superadmin\PlansRepository;
use DB;
use App\Models\Superadmin\Country\Country;

class PlansController extends Controller
{

    protected $plans;

    public function __construct(PlansRepository $plans)
    {
        $this->plans = $plans;
    }

    public function index(Request $request)
    {
        return view('backend.superadmin.plans.index');
    }

    public function create(Request $request)
    {
        $countries = DB::table(config('tables.country_table'))->pluck('name', 'id');
        $selected = DB::table(config('tables.country_table'))->where('name', 'USA')->pluck('id');
        $states = DB::table(config('tables.state_table'))->where('country_id', $selected)->pluck('name', 'id');
        return view('backend.superadmin.plans.create')->with('countries', $countries)->with('selected', $selected)->with('states', $states);
    }

    public function store(AgencycreateRequest $request)
    {
        $email = User::where('email', $request->email)->first();
        if (!empty($email)) {
            return back()->withInput()->withFlashDanger(__('Email already exists.'));
        } else {
            $userid = $this->plans->create(['data' => $request]);
            $this->plans->chargeAgency($userid, "Account Creation Upfront Fees");
            return redirect()->route('admin.superadmin.plans.index')->withFlashSuccess(trans('alerts.backend.promocode.created'));
        }
    }

    public function show(Plans $plans, $id)
    {
        $history = DB::table('dx_currencies')->where('agency_id', $id)
            ->orderBy('id', 'DESC')->get();

        return view('backend.superadmin.plans.show')
            ->with('history', $history);
    }

    public function edit(Plans $plan, Request $request)
    {
        $cities = DB::table('dx_cities')->where('country_id', $plan->country)->pluck('name', 'id');
        $countries = DB::table('dx_countries')->pluck('name', 'id');
        $states = DB::table('dx_states')->where('country_id', $plan->country)->pluck('name', 'id');
        return view('backend.superadmin.plans.edit')->with('plan', $plan)->with('countries', $countries)->with('cities', $cities)->with('states', $states);
    }

    public function update(Plans $plan, AgencyeditRequest $request)
    {
        $this->plans->update($plan, ['data' => $request]);
        if ($request->status == 0) {
            $agents = DB::table('dx_agents')->where('agency_id', $plan->id)->get();
            foreach ($agents as $agent) {
                DB::table('dx_agents')->where('agency_id', $plan->id)->update(['status' => $request->status]);
                DB::table('users')->where('agent_id', $agent->id)->update(['status' => $request->status, 'confirmed' => 0]);
            }
        }

        return redirect()->route('admin.superadmin.plans.index')->withFlashSuccess(trans('alerts.backend.promocode.updated'));

    }

    public function destroy($id)
    {
        DB::table('dx_agencies')->where('id', '=', $id)->delete();
        return redirect()->route('admin.superadmin.plans.index')->withFlashDanger(trans('alerts.backend.promocode.deleted'));
    }

    public function cities($id)
    {
        $cities = DB::table('dx_cities')->where('state_id', $id)->select('name', 'id')->get();
        $html = '';
        foreach ($cities as $city) {
            $html .= '<option value="' . $city->id . '">' . $city->name . '</option>';
        }
        return response()->json(['html' => $html]);
    }

    public function states($id)
    {
        $states = DB::table('dx_states')->where('country_id', $id)->select('name', 'id')->get();
        $html = '';
        foreach ($states as $state) {
            $html .= '<option value="' . $state->id . '">' . $state->name . '</option>';
        }
        return response()->json(['html' => $html]);
    }
}
