<?php

namespace App\Http\Controllers\Backend\Superadmin\Leads;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Session;
//use Maatwebsite\Excel\Excel;
use File;
use Maatwebsite\Excel\Facades\Excel;
class LeadsController extends Controller
{
    public function index()
    {
        return view('backend.superadmin.leads.index');
    }

    public function store(Request $request)
    {
        $this->validate($request, array(
            'file'      => 'required'
        ));
        if($request->hasFile('file')) {

            $extension = File::extension($request->file->getClientOriginalName());
            if ($extension == "csv") {

                $path = $request->file->getRealPath();
                $this->loadFileAndDoChunking($path, $extension);
                return redirect()->route('admin.superadmin.leads.index')->withFlashSuccess(__('Your file successfully queued for importing'));
            }
            else {
                return redirect()->route('admin.superadmin.leads.index')->withFlashDanger(__('File is a '.$extension.' file.!! Please upload a valid csv file..!!'));
            }
        }
        else {
            return redirect()->route('admin.superadmin.leads.index')->withFlashDanger(__('Please select a valid csv file..!!'));
        }
    }

    private function loadFileAndDoChunking($path, $extension) {
        $file = file($path);
        $data = array_slice($file, 1);
        //loop through file and split every 1000 lines
        $parts = (array_chunk($data, 2000));
        $i = 1;
        foreach($parts as $line) {
            $filename = base_path('resources/pendingleads/'.date('y-m-d-H-i-s') . $i . '.' . $extension);
            array_unshift($line, $file[0]);
            file_put_contents($filename, $line);
            $i++;
        }
    }

    public function chat(){
        return view('backend.superadmin.chat.index');
    }

}
