<?php

namespace App\Http\Controllers\Backend\Superadmin\Deliverysettings;

use App\Http\Requests\Backend\Superadmin\GeneralSettingRequest;
use App\Models\Superadmin\Currency\Currency;
use Faker\Provider\File;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Superadmin\Setting\Setting;
use App\Traits\DateTime;
use App\Traits\Uploads;
use App\Models\Superadmin\Country;
use DB;

class DeliverySettingsController extends Controller
{
    use DateTime, Uploads;
    protected $setting;


    public function __construct()
    {
        setting()->setExtraColumns(['user_id' => 1]);
        setting()->load(true);

        // Timezone
        config(['app.timezone' => setting('general.timezone', 'UTC')]);

        // Email
        $email_protocol = setting('general.email_protocol', 'mail');
        config(['mail.driver' => $email_protocol]);
        config(['mail.from.name' => setting('general.company_name')]);
        config(['mail.from.address' => setting('general.company_email')]);

        if ($email_protocol == 'sendmail') {
            config(['mail.sendmail' => setting('general.email_sendmail_path')]);
        } elseif ($email_protocol == 'smtp') {
            config(['mail.host' => setting('general.email_smtp_host')]);
            config(['mail.port' => setting('general.email_smtp_port')]);
            config(['mail.username' => setting('general.email_smtp_username')]);
            config(['mail.password' => setting('general.email_smtp_password')]);
            config(['mail.encryption' => setting('general.email_smtp_encryption')]);
        }

        // Locale
        if (session('locale') == '') {
            config(['app.locale' => setting('general.default_locale')]);
        }

    }


    public function index($type="")
    {
        if(isset($type) && $type!="")
        {
            $setting = Setting::all()->map(function($s) {
                $s->key = str_replace('general.', '', $s->key);//general. = $type
                return $s;
            })->pluck('value', 'key');

        }
        else
        {
            $setting = Setting::all()->map(function($s)
            {
                $s->key = str_replace('general.', '', $s->key);
                return $s;
            })->pluck('value', 'key');
        }

        $timezones = $this->getTimezones();
        $currencyy = Currency::all()->pluck('currency_code', 'id');
        $countries = Country\Country::all()->pluck('name', 'id');

        $date_formats = [
            'd M Y' => '31 Dec 2017',
            'd F Y' => '31 December 2017',
            'd m Y' => '31 12 2017',
            'm d Y' => '12 31 2017',
            'Y m d' => '2017 12 31'
        ];


        $date_separators = [
            'dash' => trans('settings.localisation.date.dash'),
            'slash' => trans('settings.localisation.date.slash'),
            'dot' => trans('settings.localisation.date.dot'),
            'comma' => trans('settings.localisation.date.comma'),
            'space' => trans('settings.localisation.date.space'),
        ];

        $email_protocols = [
            'mail' => trans('settings.email.php'),
            'smtp' => trans('settings.email.smtp.name'),
            'sendmail' => trans('settings.email.sendmail'),
            'log' => trans('settings.email.log')
        ];

        if($type=="paymentgateways")
        {
            return view('backend.superadmin.settings.paymentgateway')->with('setting' , $setting);//, compact('setting','date_formats', 'date_separators', 'email_protocols','timezones'));
        }
        elseif ($type=="seo"){
            return view('backend.superadmin.settings.seo');
        }
        elseif($type=="smsgateway")
        {
            return view('backend.superadmin.settings.smsgateway', compact('setting','date_formats', 'date_separators', 'email_protocols','timezones'));
        }
        elseif($type=="mobilesettings")
        {
            return view('backend.superadmin.settings.mobilesettings', compact('setting','date_formats', 'date_separators', 'email_protocols','timezones'));
        }
        else
        {
            return view('backend.superadmin.settings.index', compact('setting','date_formats', 'date_separators', 'email_protocols','timezones','countries','currencyy'));
        }
    }

    public function update(Request $request)
    {
        $fields = $request->all();
        $company_id = 1; //$request->get('user_id');
        $skip_keys = ['user_id', '_method', '_token'];
        $file_keys = ['desktop_logo','mobile_development','mobile_production'];

        foreach ($fields as $key => $value) {
            // Don't process unwanted keys
            if (in_array($key, $skip_keys)) {
                continue;
            }

            // Process file uploads
            if (in_array($key, $file_keys)) {
                $value = $this->getUploadedFilePath($request->file($key), 'settings');

                // Prevent reset
                if (empty($value)) {
                    continue;
                }
            }

            setting()->set('general.' . $key, $value);
        }

        // Save all settings
        setting()->save();

        $message = trans('messages.success.updated', ['type' => trans_choice('general.settings', 2)]);
        flash($message)->success();

        return redirect('/admin/superadmin/settings')->withFlashSuccess(trans('alerts.backend.team.save'));
    }



}
