<?php

namespace App\Http\Controllers\Backend\Superadmin\Currency;

use App\Http\Controllers\Controller;
use App\Repositories\Backend\Superadmin\CurrencyRepository;
use Yajra\Datatables\Facades\Datatables;
use App\Models\Superadmin\Plans\Plans;

class CurrencyTableController extends Controller
{


    protected $currency;


    public function __construct(CurrencyRepository $currency)
    {
        $this->currency = $currency;
    }

    public function __invoke() {

        return Datatables::of($this->currency->getForDataTable())
            ->addColumn('actions', function($currency) {
                return $currency->action_buttons;

            })
            ->editColumn('agency_id',function ($status){
                $agency_id = Plans::where('id',$status->agency_id)->first();
                return isset($agency_id->agency_name) ? $agency_id->agency_name : 'No Name Available';
            })
            ->editColumn('created_at', function ($var){
                return $var->created_at->toFormattedDateString();
            })->rawColumns(['actions'])

            ->make(true);
    }
}
