<?php

namespace App\Http\Controllers\Backend\Superadmin\Currency;


use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Superadmin\WalletcreateRequest;
use App\Models\Superadmin\Currency\Currency;
use Illuminate\Http\Request;
use App\Repositories\Backend\Superadmin\CurrencyRepository;
use DB;
class CurrencyController extends Controller
{

    protected $currency;

    public function __construct(CurrencyRepository $currency)
    {
        $this->currency = $currency;
    }

    public function index(Request $request)
    {
        return view('backend.superadmin.currency.index');
    }


    public function create(Request $request)
    {
        $agency = DB::table('dx_agencies')->where('status',1)
            ->pluck('agency_name', 'id');
        return view('backend.superadmin.currency.create',['agency'=>$agency]);
    }


    public function store(WalletcreateRequest $request)
    {
        $results = DB::table('dx_agencies')->where('id',$request->agency_id)->first();
//        dd($results);
        $this->currency->create(['data' => $request]);
        $currentbalance = $results->balance + $request->amount;

        DB::table('dx_agencies')->where('id', $request->agency_id)->update(['balance' => $currentbalance]);

        return redirect()->route('admin.superadmin.currency.index')->withFlashSuccess(trans('Successfully'));
    }

}