<?php
/**
 * Created by PhpStorm.
 * User: Sohaib
 * Date: 2/20/2019
 * Time: 3:50 PM
 */
namespace App\Http\Controllers\Backend\Superadmin\Agents;

use App\Http\Controllers\Controller;
use App\Models\Superadmin\Plans\Plans;
use App\Repositories\Backend\Superadmin\AgentsRepository;
use Yajra\Datatables\Facades\Datatables;

/***/

class AgentsTableController extends Controller
{

    protected $agents;

    public function __construct(AgentsRepository $agents)
    {
        $this->agents = $agents;
    }

    public function __invoke() {

        return DataTables::of($this->agents->getForDataTable())
            ->addColumn('actions', function($agents) {
                return $agents->action_buttons;
            })
            ->editColumn('status', function ($status){
                if($status->status==1){return "Active";}
                else if($status->status==0){return "Disabled";}
            })
            ->editColumn('agency_id',function ($status){
                $agency_id = Plans::where('id',$status->agency_id)->first();
                return isset($agency_id->agency_name) ? $agency_id->agency_name : 'No Name Available';
            })
            ->rawColumns(['actions'])
            ->make(true);
    }
}
