<?php



namespace App\Http\Controllers\Backend\Superadmin\Agents;



use App\Http\Controllers\Controller;

use App\Models\Superadmin\Agents\Agents;

use Illuminate\Http\Request;

use App\Repositories\Backend\Superadmin\AgentsRepository;

use DB;

use App\Models\Superadmin\Plans\Plans;

use Illuminate\Support\Facades\Hash;

use DateTime;

use App\Http\Requests\Backend\Superadmin\CreateagentRequest;
use Illuminate\Support\Facades\Auth;
class AgentsController extends Controller

{



    protected $agent;



    public function __construct(AgentsRepository $agent)

    {

        $this->agent = $agent;

    }



    public function index()

    {

        return view('backend.superadmin.agents.index');

    }



    public function create()

    {

        $agency = Plans::all()->where('status',1)->pluck('agency_name', 'id');

        return view('backend.superadmin.agents.create',['agency'=>$agency]);

    }

    public function store(CreateagentRequest $request)

    {
//        dd('superadmin');
        $current_user = Auth::user();
//dD($current_user->agency_id);

        $email = DB::table('dx_agents')->where('email', $request->email)->first();

        $useremail = DB::table('users')->where('email', $request->email)->first();

        if(empty($email->email) && empty($useremail->email)) {

            $agent = new Agents([

                'first_name' => $request->get('first_name'),

                'last_name' => $request->get('last_name'),

                'phone'=> $request->get('phone'),

                'mobile' => $request->get('mobile'),

                'email' => $request->get('email'),

                'agency_id' => $current_user->agency_id

            ]);

            $agent->save();

            $insertedId = $agent->id;
//dd($insertedId);
            $data = array(

                'first_name'            => $request->first_name,

                'last_name'            => $request->last_name,

                'email' =>  $request->email,

                'password' => Hash::make($request->password),

                'status'    => 1,

                'confirmed' => 1,

                'agent_id'  => $insertedId,

                'confirmation_code' => md5(uniqid(mt_rand(), true)),

                'created_at'    =>  new DateTime(),

                'updated_at'    =>  new DateTime(),

                );

            $user = DB::table('users')->insert($data);



            $id = DB::getPdo()->lastInsertId();

//            dd($id);



            $role = array(

                'user_id'            => $id,

                'role_id'            => 3,

            );

            DB::table('role_user')->insert($role);



            return redirect()->route('admin.superadmin.agents.index')->withFlashSuccess(__('The agent was successfully created.'));

        } else {

            return back()->withInput()->withFlashDanger(__('Email already exists.'));

        }

    }

    public function edit($id)

    {

        $agent = Agents::first()->where('id', '=', $id)->first();

        $agency = Plans::all()->where('status',1)->pluck('agency_name', 'id');

        return view('backend.superadmin.agents.edit',['agent'=>$agent,'agency'=>$agency]);

    }

    public function update(Agents $agent, CreateagentRequest $request)

    {

//        dd($agent);

        $this->agent->update($agent, ['data' => $request]);

        DB::table('users')->where('agent_id', $agent->id)->update([

            'email'          => $request->email,

            'status'          => $request->status,

        ]);

        return redirect()->route('admin.superadmin.agents.index')->withFlashSuccess(__('The agent was successfully updated. '));



    }

    public function deleteagent($id)

    {

        $user = DB::table('agents')->where('id', $id)->first();

        DB::table('users')->where('email', $user->email)->delete();

        DB::table('agents')->where('id', $id)->delete();

        return redirect()->route('admin.superadmin.agent.index')->withFlashSuccess(__('The agent was successfully deleted. '));

    }

    public function show($id)

    {

//        dd($id);

        $agent= DB::table('dx_agents')->where('id', '=', $id)->first();

        $agency= DB::table('dx_agencies')->where('id', '=', $agent->agency_id)->first();

        return view('backend.superadmin.agents.show',['agent'=>$agent,'agency'=>$agency]);

    }

}

