<?php

namespace App\Http\Controllers\Backend;
use DB;
use Auth;
use App\Http\Controllers\Controller;
use App\Models\Customers\Leads\Leads;
use App\Models\Superadmin\Plans\Plans;
use App\Models\Superadmin\Agents\Agents;
use App\Models\Superadmin\Currency\Currency;
use Charts;
use App\Models\Access\User\User;
use App\Models\Superadmin\Transfers\Transfers;

/**
 * Class DashboardController.
 */
class DashboardController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $user_id = Auth()->id();
        DB::table('users')->where('id', $user_id)->update(['online' => 1]);

        if(access()->hasRole('Administrator'))
        {
            $agencies = Plans::all()->count();
            $agents = Agents::all()->count();
            $sales = Plans::sum('balance');
            $transfers = DB::table('transfers')->count();

            $unvarifyleads = Leads::where('isverfied',0)
                ->where('isvalidated',0)->count();

            $validleads = Leads::where('isverfied',1)
                ->where('isvalidated',1)->count();


            $online = DB::table('users')->where('online', 1)->get()->count();
            $online = $online - 1;

            $totalusers = DB::table('users')->where('confirmed', 1)->get()->count();
            $totalusers = $totalusers - 1;

            $Janfrom = date('2019-12-31');
            $Janto = date('2019-02-01');
            $Jan = Currency::whereBetween('created_at', [$Janfrom, $Janto])->sum('amount');

            $febfrom = date('2019-01-31');
            $fabto = date('2019-03-01');
            $feb = Currency::whereBetween('created_at', [$febfrom, $fabto])->sum('amount');

            $marfrom = date('2019-02-28');
            $marto = date('2019-04-01');
            $mar = Currency::whereBetween('created_at', [$marfrom, $marto])->sum('amount');

            $aprfrom = date('2019-03-31');
            $aprto = date('2019-05-01');
            $apr = Currency::whereBetween('created_at', [$aprfrom, $aprto])->sum('amount');

            $mayfrom = date('2019-04-30');
            $mayto = date('2019-06-01');
            $may = Currency::whereBetween('created_at', [$mayfrom, $mayto])->sum('amount');

            $junefrom = date('2019-05-31');
            $juneto = date('2019-07-01');
            $june = Currency::whereBetween('created_at', [$junefrom, $juneto])->sum('amount');

            $julyfrom = date('2019-06-30');
            $julyto = date('2019-08-01');
            $july = Currency::whereBetween('created_at', [$julyfrom, $julyto])->sum('amount');

            $augfrom = date('2019-07-31');
            $augto = date('2019-09-01');
            $aug = Currency::whereBetween('created_at', [$augfrom, $augto])->sum('amount');

            $sepfrom = date('2019-08-31');
            $septo = date('2019-10-01');
            $sep = Currency::whereBetween('created_at', [$sepfrom, $septo])->sum('amount');

            $octfrom = date('2019-09-30');
            $octto = date('2019-11-01');
            $oct = Currency::whereBetween('created_at', [$octfrom, $octto])->sum('amount');

            $novfrom = date('2019-10-31');
            $novto = date('2019-12-01');
            $nov = Currency::whereBetween('created_at', [$novfrom, $novto])->sum('amount');

            $decfrom = date('2019-11-30');
            $decto = date('2020-01-01');
            $dec = Currency::whereBetween('created_at', [$decfrom, $decto])->sum('amount');

            $chart =  Charts::create('bar', 'highcharts')
                ->title('Monthly Sales')
                ->elementLabel('Year 2019')

                ->labels(['January','February','March','April','May','June','July','August','September','October','November','December'])
                ->values([$Jan,$feb,$mar,$apr,$may,$june,$july,$aug,$sep,$oct,$nov,$dec])

                ->dimensions(1000,500)
                ->responsive(false);

            $users = DB::table('transfers')
                ->leftJoin('users', 'transfers.caller_id', '=', 'users.id')
                ->select('transfers.caller_id','users.first_name', DB::raw('count(*) as total'))
                ->groupBy('caller_id')
                ->get();

            $userNames = [];
            foreach ($users as $user) {
                array_push($userNames, $user->first_name);
            }

            $totalCalls = [];
            foreach ($users as $user) {
                array_push($totalCalls, $user->total);
            }

            $caller_chart =  Charts::create('bar', 'highcharts')
                ->title('Monthly Transfers Caller wise')
                ->elementLabel('Year 2019')

                ->labels($userNames)
                ->values($totalCalls)

                ->dimensions(1000,500)
                ->responsive(false);


            return view('backend.dashboard',['agencies'=>$agencies,'agents'=>$agents,'sales'=>$sales,'transfers'=>$transfers,'chart'=>$chart,'online'=>$online,'totalusers'=>$totalusers,'unvarifyleads'=>$unvarifyleads,'validleads'=>$validleads,'caller_chart'=>$caller_chart]);
        }
        else
        {
            if(access()->hasRole('Caller')){
            $user_id = Auth::id();

            $unvarifyleads = Leads::where('isverfied',0)
                ->where('isvalidated',0)->count();
            $validleads = Leads::where('isverfied',1)
                ->where('isvalidated',1)->count();

            $transfers = DB::table('transfers')->where('caller_id',$user_id)->get()->count();

                $Janfrom = date('2019-12-31');
                $Janto = date('2019-02-01');
                $Jan = DB::table('transfers')->whereBetween('created_at', [$Janfrom, $Janto])
                    ->where('caller_id',$user_id)->count();

                $febfrom = date('2019-01-31');
                $fabto = date('2019-03-01');
                $feb = DB::table('transfers')->whereBetween('created_at', [$febfrom, $fabto])
                    ->where('caller_id',$user_id)->count();

                $marfrom = date('2019-02-28');
                $marto = date('2019-04-01');
                $mar = DB::table('transfers')->whereBetween('created_at', [$marfrom, $marto])
                    ->where('caller_id',$user_id)->count();

                $aprfrom = date('2019-03-31');
                $aprto = date('2019-05-01');
                $apr = DB::table('transfers')->whereBetween('created_at', [$aprfrom, $aprto])
                    ->where('caller_id',$user_id)->count();

                $mayfrom = date('2019-04-30');
                $mayto = date('2019-06-01');
                $may = DB::table('transfers')->whereBetween('created_at', [$mayfrom, $mayto])
                    ->where('caller_id',$user_id)->count();

                $junefrom = date('2019-05-31');
                $juneto = date('2019-07-01');
                $june = DB::table('transfers')->whereBetween('created_at', [$junefrom, $juneto])
                    ->where('caller_id',$user_id)->count();

                $julyfrom = date('2019-06-30');
                $julyto = date('2019-08-01');
                $july = DB::table('transfers')->whereBetween('created_at', [$julyfrom, $julyto])
                    ->where('caller_id',$user_id)->count();

                $augfrom = date('2019-07-31');
                $augto = date('2019-09-01');
                $aug = DB::table('transfers')->whereBetween('created_at', [$augfrom, $augto])
                    ->where('caller_id',$user_id)->count();

                $sepfrom = date('2019-08-31');
                $septo = date('2019-10-01');
                $sep = DB::table('transfers')->whereBetween('created_at', [$sepfrom, $septo])
                    ->where('caller_id',$user_id)->count();

                $octfrom = date('2019-09-30');
                $octto = date('2019-11-01');
                $oct = DB::table('transfers')->whereBetween('created_at', [$octfrom, $octto])
                    ->where('caller_id',$user_id)->count();

                $novfrom = date('2019-10-31');
                $novto = date('2019-12-01');
                $nov = DB::table('transfers')->whereBetween('created_at', [$novfrom, $novto])
                    ->where('caller_id',$user_id)->count();

                $decfrom = date('2019-11-30');
                $decto = date('2020-01-01');
                $dec = DB::table('transfers')->whereBetween('created_at', [$decfrom, $decto])
                    ->where('caller_id',$user_id)->count();

                $chart =  Charts::create('bar', 'highcharts')
                    ->title('Monthly Leads Transfer')
                    ->elementLabel('Year 2019')

                    ->labels(['January','February','March','April','May','June','July','August','September','October','November','December'])
                    ->values([$Jan,$feb,$mar,$apr,$may,$june,$july,$aug,$sep,$oct,$nov,$dec])

                    ->dimensions(1000,500)
                    ->responsive(false);

                return view('backend.dashboard-customer',['unvarifyleads'=>$unvarifyleads,'validleads'=>$validleads,'transfers'=>$transfers,'chart'=>$chart]);
            }
            if(access()->hasRole('Agent')){
                $user_id = Auth::user()->agent_id;
                $transfers = DB::table('transfers')->where('agent_id',$user_id)->get()->count();

                $Janfrom = date('2019-12-31');
                $Janto = date('2019-02-01');
                $Jan = DB::table('transfers')->whereBetween('created_at', [$Janfrom, $Janto])
                        ->where('agent_id',$user_id)->count();

                $febfrom = date('2019-01-31');
                $fabto = date('2019-03-01');
                $feb = DB::table('transfers')->whereBetween('created_at', [$febfrom, $fabto])
                    ->where('agent_id',$user_id)->count();

                $marfrom = date('2019-02-28');
                $marto = date('2019-04-01');
                $mar = DB::table('transfers')->whereBetween('created_at', [$marfrom, $marto])
                    ->where('agent_id',$user_id)->count();

                $aprfrom = date('2019-03-31');
                $aprto = date('2019-05-01');
                $apr = DB::table('transfers')->whereBetween('created_at', [$aprfrom, $aprto])
                    ->where('agent_id',$user_id)->count();

                $mayfrom = date('2019-04-30');
                $mayto = date('2019-06-01');
                $may = DB::table('transfers')->whereBetween('created_at', [$mayfrom, $mayto])
                    ->where('agent_id',$user_id)->count();

                $junefrom = date('2019-05-31');
                $juneto = date('2019-07-01');
                $june = DB::table('transfers')->whereBetween('created_at', [$junefrom, $juneto])
                    ->where('agent_id',$user_id)->count();

                $julyfrom = date('2019-06-30');
                $julyto = date('2019-08-01');
                $july = DB::table('transfers')->whereBetween('created_at', [$julyfrom, $julyto])
                    ->where('agent_id',$user_id)->count();

                $augfrom = date('2019-07-31');
                $augto = date('2019-09-01');
                $aug = DB::table('transfers')->whereBetween('created_at', [$augfrom, $augto])
                    ->where('agent_id',$user_id)->count();

                $sepfrom = date('2019-08-31');
                $septo = date('2019-10-01');
                $sep = DB::table('transfers')->whereBetween('created_at', [$sepfrom, $septo])
                    ->where('agent_id',$user_id)->count();

                $octfrom = date('2019-09-30');
                $octto = date('2019-11-01');
                $oct = DB::table('transfers')->whereBetween('created_at', [$octfrom, $octto])
                    ->where('agent_id',$user_id)->count();

                $novfrom = date('2019-10-31');
                $novto = date('2019-12-01');
                $nov = DB::table('transfers')->whereBetween('created_at', [$novfrom, $novto])
                    ->where('agent_id',$user_id)->count();

                $decfrom = date('2019-11-30');
                $decto = date('2020-01-01');
                $dec = DB::table('transfers')->whereBetween('created_at', [$decfrom, $decto])
                    ->where('agent_id',$user_id)->count();

                $chart =  Charts::create('bar', 'highcharts')
                    ->title('Monthly Leads Transfer')
                    ->elementLabel('Year 2019')

                    ->labels(['January','February','March','April','May','June','July','August','September','October','November','December'])
                    ->values([$Jan,$feb,$mar,$apr,$may,$june,$july,$aug,$sep,$oct,$nov,$dec])

                    ->dimensions(1000,500)
                    ->responsive(false);

                return view('backend.dashboard-customer',['transfers'=>$transfers,'chart'=>$chart]);
            }
            if(access()->hasRole('Agency')){

                $tempp = DB::table('dx_agencies')->select('id')->where('id',auth()->user()->agency_id)->first();
                $online = DB::table('users')->where('agency_id' , $tempp->id)->first();
                $total_aget = DB::table('dx_agents')->where('agency_id' , $online->agency_id)->get();
                $total_agents = count($total_aget);
                $active_users = [];

                foreach ($total_aget as $my_users){
                    $var = DB::table('users')->where('agent_id',$my_users->id)->where('online',1)
                        ->first();
                    if($var != NULL){
                        $active_users[] = $var;
                    }
                }
                $active_users = count($active_users);
                return view('backend.dashboard-customer',['total_agents'=>$total_agents,'active_users'=>$active_users]);
            }
        }
    }
    
    public function getUnreadMessageCount()
    {
        return \App\Message::where('to', auth()->user()->id)->where('read', null)->count();
    }
}
