<?php

namespace App\Http\Controllers\Backend\Customers\Validleads;

use App\Http\Controllers\Controller;
use App\Repositories\Backend\Customers\ValidleadsRepository;
use Yajra\Datatables\Facades\Datatables;
use App\Models\Customers\Agents\Agents2;

class ValidleadsTableController extends Controller
{

    protected $validleads;

    public function __construct(ValidleadsRepository $validleads)
    {
        $this->validleads = $validleads;
    }

    public function __invoke() {

        return Datatables::of($this->validleads->getForDataTable())
            ->addColumn('actions', function($validleads) {
                return $validleads->action_buttons;
            })
            ->rawColumns(['actions'])
            ->make(true);
    }
}
