<?php

namespace App\Http\Controllers\Backend\Customers\Validleads;

use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use App\Models\Customers\Leads\Validleads;
use App\Models\Superadmin\Agents\Agents;
use App\Models\Access\User\User;
use App\Models\Superadmin\Plans\Plans;
use Illuminate\Http\Request;
use DB;
use App\Repositories\Backend\Customers\ValidleadsRepository;
use DateTime;
use Jackpopp\GeoDistance\GeoDistanceTrait;

class ValidleadsController extends Controller
{
    protected $validleads;

    public function __construct(ValidleadsRepository $validleads)
    {
        $this->validleads = $validleads;
    }

    public function index(Request $request)
    {
        return view('backend.customers.validleads.index');
    }

    public function edit($id)
    {
        $agents = User::all()->where('agent_id', '!=', null)->where('online', 1)
            ->pluck('first_name', 'agent_id');
        $result = DB::table('leads')->where('id', $id)->first();
        $leads = new Validleads;
        $table = $leads->getTableColumns();

        return view('backend.customers.validleads.edit', ['result' => $result, 'agents' => $agents, 'table' => $table]);
    }

    public function mydata($id)
    {
        $agent = Agents::where('id', $id)->first();
        $agency = Plans::where('id', $agent->agency_id)->first();

        $data = array(
            'first_name' => $agent->first_name,
            'last_name' => $agent->last_name,
            'phone' => $agent->phone,
            'mobile' => $agent->mobile,
            'email' => $agent->email,
            'agency' => $agency->agency_name,
        );

        return $data;
    }

    public function mydataagencyop($id)
    {
        $re = DB::table('users')->where('id', $id)->first();
        $result = DB::table('agents')->where('email', $re->email)->first();
        $agency = Agency::where('id', $result->agency_id)->first();
        return $agency;
    }

    public function update(Request $request, $id)
    {

        $result = DB::table('dx_agents')->where('id', $request->agent_id)->first();
        $balance = DB::table('dx_agencies')->where('id', $result->agency_id)->first();
        if ($balance->balance == 0) {
            return redirect()->route('admin.customers.validleads.index')->withFlashDanger(trans('Agency\'s balance is not enough to transfer a lead'));
        }
        $subbalance = $balance->balance - $balance->transection_price;

        DB::table('dx_agencies')->where('id', $balance->id)->update([
            'balance' => $subbalance,
        ]);

        DB::table('leads')->where('id', $id)->update([
            'transferto' => $request->agent_id,
        ]);

        $caller_id = Auth::id();
        $data = array(
            'lead_id' => $id,
            'caller_id' => $caller_id,
            'agent_id' => $request->agent_id,
            'agency_id' => $balance->id,
            'fields' => json_encode($request['services']),
            'created_at' => new DateTime(),
        );
        DB::table('transfers')->insert($data);

        return redirect()->route('admin.customers.validleads.index')->withFlashSuccess(trans('Lead Transfer Successfully'));
    }

    public function show($id)
    {
        $result = DB::table('leads')->where('id', $id)->first();
        return view('backend.customers.validleads.show', ['result' => $result]);
    }
}