<?php

namespace App\Http\Controllers\Backend\Customers\Leads;
use App\Models\Customers\Leads\Traits\Attribute\LeadsAttribute;
use Arcanedev\Support\Bases\Model;
use Jcf\Geocode\Geocode;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use App\Models\Customers\Leads\Leads;
use Illuminate\Http\Request;
use App\Http\Requests\Backend\Customers\ContactsRequest;
use DB;
use App\Repositories\Backend\Customers\LeadsRepository;
/**
 * Class ContactsController
 */
class LeadsController extends Controller
{

    protected $leads;



    public function __construct(LeadsRepository $leads)
    {
        $this->leads = $leads;
    }

    public function index(Request $request)
    {
        $coloumn = [];
        $userid = Auth::user()->id;

        $settings = DB::table('dx_settings')
            ->where('user_id',$userid)
            ->where('value',1)
            ->get();

        foreach($settings as $set){
            $set->key = str_replace('general.','',$set->key);
            array_push($coloumn,$set->key);
        }
        if ($settings->count() > 0)
        {
            $count = 1;
        }else{
            $count = 0;
        }

        return view('backend.customers.leads.index',['settings'=>$settings,'count'=>$count]);
    }

    public function create(Request $request)
    {

        return view('backend.customers.contacts.create');
    }


    public function store(ContactsRequest $request)
    {

        $this->contacts->create(['data' => $request]);
        return redirect()->route('admin.customers.contacts.index')->withFlashSuccess(trans('alerts.backend.contacts.created'));
    }


    public function show(Leads $contacts, Request $request) {

        return view('backend.show')
            ->with('currency',$contacts);
    }


    public function edit($id)
    {

        $result = DB::table('leads')->where('id',$id)->first();
//        dd($results->fname);
        return view('backend.customers.leads.edit',['result'=>$result]);
    }

    public function update(Request $request, $id)
    {
        DB::table('leads')
            ->where('id', $id)
            ->update([
                'isverfied'          => $request->isverfied,
//                'isvalidated'              => $request->isvalidated,
            ]);
        return redirect()->route('admin.customers.leads.index')->withFlashSuccess(trans('Lead Validated'));
    }


    public function destroy(Leads $contact, Request $request)
    {
        $this->contacts->delete($contact);
        return redirect()->route('admin.customers.contacts.index')->withFlashSuccess(trans('alerts.backend.contacts.deleted'));
    }
}