<?php

namespace App\Http\Controllers\Backend\Agents\Leads;

use App\Http\Controllers\Controller;
use App\Repositories\Backend\Agents\LeadsRepository;
use Yajra\Datatables\Facades\Datatables;




class LeadsTableController extends Controller
{

    protected $leads;

    public function __construct(LeadsRepository $leads)
    {
        $this->leads = $leads;
    }

    public function __invoke() {

        return Datatables::of($this->leads->getForDataTable())
            ->addColumn('actions', function($leads) {
                return $leads->action_buttons;
            })
            ->rawColumns(['actions'])
            ->make(true);
    }

    public function __getinvoke(){

        return DataTables::of($this->leads->getForCustomeDataTable())
            ->addColumn('actions', function($leads) {
                return $leads->action_buttons;
            })
            ->rawColumns(['actions'])
            ->make(true);
    }
}
