<?php

/**

 * Created by PhpStorm.

 * User: Sohaib

 * Date: 3/21/2019

 * Time: 10:45 PM

 */

namespace App\Http\Controllers\Backend\Agents\Leads;

use App\Models\Customers\Leads\Traits\Attribute\LeadsAttribute;

use Arcanedev\Support\Bases\Model;

use Jcf\Geocode\Geocode;

use Illuminate\Support\Facades\Auth;

use App\Http\Controllers\Controller;

use App\Models\Agents\Leads\Leads;

use Illuminate\Http\Request;

use App\Http\Requests\Backend\Customers\ContactsRequest;

use DB;

use App\Repositories\Backend\Agents\LeadsRepository;

/**

 * Class LeadController

 */

class LeadsController extends Controller

{



    protected $leads;







    public function __construct(LeadsRepository $leads)

    {

        $this->leads = $leads;

    }



    public function index(Request $request)

    {



        return view('backend.agents.leads.index');

    }



    public function show($id)

    {
        

        $userid = Auth::user();

        $fields = DB::table('transfers')

            ->where('lead_id',$id)

            ->first();

        $results = DB::table('leads')

            ->where('id',$id)

            ->first();

        $column = json_decode($fields->fields);
        // dd($column);
        if($column){
        $leads = DB::Table('leads')->select($column)

            ->where('transferto',$userid->agent_id)

            ->first();

            $astatus = '1';
            // dd($astatus);
            return view('backend.agents.leads.show',['leads'=>$leads,'results'=>$results,'astatus'=>$astatus]);
        }else{
            $leads = DB::Table('leads')->select('status')

            ->where('transferto',$userid->agent_id)

            ->first();
            $astatus = '0';

            // dd($results);
            return view('backend.agents.leads.show',['leads'=>$leads,'results'=>$results,'astatus'=>$astatus]);
        }


        

    }



    public function update(Request $request, $id)

    {

        DB::table('leads')

            ->where('id', $id)

            ->update([

                'isvalidated'              => $request->isvalidated,

            ]);

        return redirect()->route('admin.agents.leads.index')->withFlashSuccess(trans('Lead Validated'));

    }

}